<?php

namespace Modules\Entertainment\database\seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Arr;
use Modules\Entertainment\Models\Entertainment;
use Modules\Entertainment\Models\EntertainmentTalentMapping;
use Modules\Entertainment\Models\EntertainmentGenerMapping;
use Illuminate\Support\Facades\Schema;
use Modules\Entertainment\Models\EntertainmentStreamContentMapping;
use Illuminate\Support\Facades\Storage;
use Carbon\Carbon;
use Modules\Entertainment\Models\EntertainmentCountryMapping;

class EntertainmentDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Schema::disableForeignKeyConstraints();

        $entertainments = [
            [
                'name' => 'The Smiling Shadows',
                'thumbnail_url' => '/dummy-images/entertainment/tvshow/thumb/the_smiling_shadows_thumb.webp',
                'poster_url' => '/dummy-images/entertainment/tvshow/poster/the_smiling_shadows_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/tvshow/thumb/the_smiling_shadows_thumb.webp',
                'description' => 'A chilling tale where sinister smiles hide dark secrets and haunting mysteries. 😱👻',
                'trailer_url_type' => 'YouTube',
                'type' => 'tvshow',
                'trailer_url' => 'https://youtu.be/7_MJp5AbSwA?si=Mtx9h0wlxtn4o_2Q',
                'movie_access' => 'free',
                'status' => 1,
                'language' => 'english',
                'IMDb_rating' => 7.5,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '05:20',
                'release_date' => '2019-04-23',
                'is_restricted' => true,
                'created_by' => 1,
                'updated_by' => 1,
                'genre_id' => [5,1,3],
                'actors' =>[1,2,3,8,9,10,13,14,15,18,20],
                'directors' => [21,24,25,26,27,28,29,30,34,35,36,39,40],
                'countries' => [1,45,78,25],
            ],
            [
                'name' => 'Gunslinger\'s Justice',
                'thumbnail_url' => '/dummy-images/entertainment/tvshow/thumb/gunslingers_justice_thumb.png',
                'poster_url' => '/dummy-images/entertainment/tvshow/poster/gunslingers_justice_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/tvshow/thumb/gunslingers_justice_thumb.png',
                'description' => 'Witness the relentless quest of a gunslinger for justice in a town plagued by corruption and violence. 🌵🔫',
                'trailer_url_type' => 'YouTube',
                'type' => 'tvshow',
                'trailer_url' => 'https://youtu.be/ob8iKn-gLFI?si=sUpU_bMpIDocTFZ6',
                'movie_access' => 'paid',
                'plan_id' => 1,
                'status' => 1,
                'language' => 'english',
                'IMDb_rating' => 8.0,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '03:21',
                // 'release_date' => '2020-05-03',
                'release_date' => Carbon::today()->addDays(rand(1, 30)),
                'is_restricted' => true,
                'created_by' => 1,
                'updated_by' => 1,
                'genre_id' => [2,4,6],
                'actors' => [4,5,6,7,11,12,13,16,17,19,20],
                'directors' => [22,23,24,28,29,30,31,32,34,36,37,38,40],
                'countries' => [12,35,55],

            ],
            [
                'name' => 'Raziel\'s Daring Rescue',
                'thumbnail_url' => '/dummy-images/entertainment/tvshow/thumb/raziels_daring_rescue_thumb.png',
                'poster_url' => '/dummy-images/entertainment/tvshow/poster/raziels_daring_rescue_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/tvshow/thumb/raziels_daring_rescue_thumb.png',
                'description' => 'In this tv show, embark on a magical journey with Raziel, a courageous young hero, who sets out to rescue his friend from the clutches of the wicked Gothel. Alongside a band of loyal companions, Raziel navigates enchanted forests, treacherous mountains, and mystical realms, overcoming obstacles and discovering the true meaning of friendship and bravery. This captivating adventure, filled with breathtaking animation and heartwarming moments, will enchant viewers of all ages. 🌟🏰✨',
                'trailer_url_type' => 'YouTube',
                'type' => 'tvshow',
                'trailer_url' => 'https://youtu.be/y-OP1mCiJ5M?si=wtaEPe357ZkqQ3Xo',
                'movie_access' => 'paid',
                'plan_id' => 2,
                'status' => 1,
                'language' => 'english',
                'IMDb_rating' => 7.8,
                'content_rating' => 'PG (Parental Guidance Suggested)',
                'duration' => '04:25',
                // 'release_date' => '2021-06-09',
                'release_date' => Carbon::today()->addDays(rand(1, 30)),
                'is_restricted' => true,
                'created_by' => 1,
                'updated_by' => 1,
                'genre_id' => [2,7,8],
                'actors' =>[1,3,4,5,6,8,10,11,12,13,14,17,18],
                'directors' => [23,24,25,26,27,28,30,32,33,34,35,36,37,39],
                'countries' => [2,8,20],
            ],
            [
                'name' => 'Shadow Pursuit',
                'thumbnail_url' => '/dummy-images/entertainment/tvshow/thumb/shadow_pursuit_thumb.png',
                'poster_url' => '/dummy-images/entertainment/tvshow/poster/shadow_pursuit_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/tvshow/thumb/shadow_pursuit_thumb.png',
                'description' => 'With each clue, the mystery deepens, leading to shocking revelations and deadly encounters. As James races against time, he discovers that the chase is personal, and failure is not an option. 🔍🕵️‍♂️',
                'trailer_url_type' => 'YouTube',
                'type' => 'tvshow',
                'trailer_url' => 'https://youtu.be/T5UokLYVJMI?si=7DVFmcXSmf5zVGKj',
                'movie_access' => 'paid',
                'plan_id' => 3,
                'status' => 1,
                'language' => 'english',
                'IMDb_rating' => 8.2,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '05:50',
                'release_date' => '2022-08-05',
                'is_restricted' => true,
                'created_by' => 1,
                'updated_by' => 1,
                'genre_id' => [8,6,4],
                'actors' =>[2,4,7,8,9,12,13,14,15,16,19,20],
                'directors' => [24,25,26,27,28,29,30,31,32,34,36,37,38,40],
                'countries' => [1,64,23,78],
            ],
            [
                'name' => 'Veil of Darkness',
                'thumbnail_url' => '/dummy-images/entertainment/tvshow/thumb/veil_of_darkness_thumb.png',
                'poster_url' => '/dummy-images/entertainment/tvshow/poster/veil_of_darkness_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/tvshow/thumb/veil_of_darkness_thumb.png',
                'description' => 'Veil of Darkness plunges viewers into the mysterious and haunted town of Ravenwood, where malevolent forces lurk in the shadows. As the residents uncover the town\'s dark secrets, they must confront their deepest fears and battle against the growing evil that threatens to consume them. With each revelation, the veil of darkness grows thicker, challenging their courage and will to survive. 🖤👻',
                'trailer_url_type' => 'YouTube',
                'type' => 'tvshow',
                'trailer_url' => 'https://youtu.be/Lz2pAf-nuQE?si=2W0a6QbgwZjxWmk5',
                'movie_access' => 'paid',
                'plan_id' => 4,
                'status' => 1,
                'language' => 'english',
                'IMDb_rating' => 4,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '08:50',
                'release_date' => '2023-09-14',
                'is_restricted' => true,
                'created_by' => 1,
                'updated_by' => 1,
                'genre_id' => [5,3,4],
                'actors' => [3,5,6,7,8,9,10,11,12,16,17,18],
                'directors' => [21,23,24,26,28,30,32,34,35,36,37,38,39,40],
                'countries' => [19,46,88,246],
            ],
            [
                'name' => 'The Hidden Truth',
                'thumbnail_url' => '/dummy-images/entertainment/tvshow/thumb/the_hidden_truth_thumb.png',
                'poster_url' => '/dummy-images/entertainment/tvshow/poster/the_hidden_truth_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/tvshow/thumb/the_hidden_truth_thumb.png',
                'description' => 'Investigator Alex Reed delves into a labyrinth of hidden truths and deception, uncovering layers of betrayal that threaten to unravel everything he holds dear. As he pieces together the puzzle, Reed faces dangerous adversaries and uncovers shocking secrets, leading to a gripping tale of trust, treachery, and the relentless pursuit of justice. 🔍🕵️‍♂️',
                'trailer_url_type' => 'YouTube',
                'type' => 'tvshow',
                'trailer_url' => 'https://youtu.be/em1ec7BZHJw?si=MSD31eT22XrZ7ohu',
                'movie_access' => 'free',
                'status' => 1,
                'language' => 'english',
                'IMDb_rating' => 8.1,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '09:50',
                'release_date' => '2024-01-11',
                'is_restricted' => true,
                'created_by' => 1,
                'updated_by' => 1,
                'genre_id' => [8,7,6],
                'actors' =>[1,2,4,8,11,12,13,14,15,19,20],
                'directors' => [22,24,25,27,29,31,32,33,34,35,36,37],
                'countries' => [152,225,188],
            ],
            [
                'name' => 'The Forgotten Road',
                'thumbnail_url' => '/dummy-images/entertainment/tvshow/thumb/the_forgotten_road_thumb.png',
                'poster_url' => '/dummy-images/entertainment/tvshow/poster/the_forgotten_road_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/tvshow/thumb/the_forgotten_road_thumb.png',
                'description' => '🌪️ In a twisted reimagining of the Wizard of Oz, Dorothy’s granddaughter Emily is summoned to confront the terrors of a cursed realm that has haunted her family for generations. "The Forgotten Road" takes you into a nightmarish version of Oz where the whimsical magic has decayed into darkness. Dorothy Gale, now an elderly woman haunted by her past encounters, watches helplessly as her granddaughter Emily is called into the sinister world. With paranormal forces lurking in every corner, Emily must navigate a crumbling land of danger and secrets to end the torment that has plagued her family for decades. The yellow brick road leads to terror, and survival is anything but guaranteed. 🌕🖤⚡',
                'trailer_url_type' => 'YouTube',
                'type' => 'tvshow',
                'trailer_url' => 'https://youtu.be/LALlUFEGdeE?si=pG5fTkaYGyGBNMr2',
                'movie_access' => 'paid',
                'plan_id' => 1,
                'status' => 1,
                'language' => 'english',
                'IMDb_rating' => null,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '06:50',
                'release_date' => '2024-01-17',
                'is_restricted' => false,
                'created_by' => 1,
                'updated_by' => 1,
                'genre_id' => [4,7,8],
                'actors' =>  [3,4,5,6,7,10,11,14,15,16,17,18],
                'directors' => [23,24,25,26,28,29,30,32,33,34,35,36,37,39],
                'countries' => [111,158,68,95],
            ],
            [
                'name' => 'Wolfbound',
                'thumbnail_url' => '/dummy-images/entertainment/tvshow/thumb/wolfbound_thumb.png',
                'poster_url' => '/dummy-images/entertainment/tvshow/poster/wolfbound_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/tvshow/thumb/wolfbound_thumb.png',
                'description' => '🐺 Maddy, a young girl who knows her wolfblood heritage, meets Rhydian, a mysterious boy who smells like her pack. Is he one of them? Uncover secrets, face dangers, and forge unlikely bonds in this thrilling action-packed adventure! 🌕⚔️',
                'trailer_url_type' => 'YouTube',
                'type' => 'tvshow',
                'trailer_url' => 'https://youtu.be/6sxnOLRGkhw?si=WrBfEDVah3Z-vFwO',
                'movie_access' => 'free',
                'plan_id' => null,
                'status' => 1,
                'language' => 'english',
                'IMDb_rating' => 8,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '08:50',
                'release_date' => '2024-02-16',
                'is_restricted' => false,
                'created_by' => 1,
                'updated_by' => 1,
                'genre_id' => [2,1,3],
                'actors' =>  [1,3,4,8,9,10,11,13,14,16,19,20],
                'directors' => [21,22,25,26,27,28,29,30,34,35,36,39,40],
                'countries' => [110,96,83],
            ],
            [
                'name' => 'Legacy of the Tribes',
                'thumbnail_url' => '/dummy-images/entertainment/tvshow/thumb/legacy_of_the_tribes_thumb.png',
                'poster_url' => '/dummy-images/entertainment/tvshow/poster/legacy_of_the_tribes_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/tvshow/thumb/legacy_of_the_tribes_thumb.png',
                'description' => '🛡️ In the ancient world, tribal nations face an overwhelming threat as invaders seek to destroy their sacred lands. With their survival and heritage on the line, the tribes set aside differences and unite for a common cause. Guided by the strength of their ancestors, they embark on an epic journey of warfare, unity, and bravery. Together, they must defend their homeland against ruthless enemies, forging a legacy that will be remembered for generations. Their battles, bonds, and sacrifice will shape the future of their people and echo through eternity. ⚔️🔥🌟',
                'trailer_url_type' => 'YouTube',
                'type' => 'tvshow',
                'trailer_url' => 'https://youtu.be/GKq7QlNz3CA?si=E6fnSD4CvpEPcMu7',
                'movie_access' => 'free',
                'plan_id' => null,
                'status' => 1,
                'language' => 'english',
                'IMDb_rating' => 9,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '09:50',
                'release_date' => '2024-02-20',
                'is_restricted' => false,
                'created_by' => 1,
                'updated_by' => 1,
                'genre_id' => [2,7,8],
                'actors' =>[2,5,6,7,9,11,12,13,15,16,17,18],
                'directors' => [22,23,25,28,29,30,31,33,34,36,37,39,40],
                'countries' => [5,145],
            ],
            [
                'name' => 'Valiant Horizons',
                'thumbnail_url' => '/dummy-images/entertainment/tvshow/thumb/valiant_horizons_thumb.png',
                'poster_url' => '/dummy-images/entertainment/tvshow/poster/valiant_horizons_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/tvshow/thumb/valiant_horizons_thumb.png',
                'description' => '⚔️ "Valiant Horizons" plunges viewers into a world of fierce conflict and heroic quests. The series chronicles the journey of brave warriors as they confront powerful adversaries and navigate treacherous landscapes. Each episode highlights their struggles and triumphs, revealing the profound impact of their bravery on their land and people. As they face daunting challenges and forge alliances, their actions determine the fate of their world, making "Valiant Horizons" a riveting tale of honor, strategy, and relentless courage. 🌟🔥⚔️',
                'trailer_url_type' => 'YouTube',
                'type' => 'tvshow',
                'trailer_url' => 'https://youtu.be/aDyQxtg0V2w?si=ydtmf91vHvNuvVMX',
                'movie_access' => 'paid',
                'plan_id' => 2,
                'status' => 1,
                'language' => 'english',
                'IMDb_rating' => 6,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '04:25',
                'release_date' => '2024-03-01',
                'is_restricted' => false,
                'created_by' => 1,
                'updated_by' => 1,
                'genre_id' => [4,8,7,6],
                'actors' => [4,8,9,10,12,13,16,17,18,19,20],
                'directors' => [23,24,25,26,27,28,30,32,33,34,35,36,37,39],
                'countries' => [122,118,128],
            ],
            [
                'name' => 'War Chronicles',
                'thumbnail_url' => '/dummy-images/entertainment/tvshow/thumb/war_chronicles_thumb.png',
                'poster_url' => '/dummy-images/entertainment/tvshow/poster/war_chronicles_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/tvshow/thumb/war_chronicles_thumb.png',
                'description' => '🛡️ "War Chronicles" takes viewers deep into the heart of historical and futuristic battles, where the fate of nations hangs in the balance. Each episode explores different warfare scenarios, highlighting the bravery of soldiers, the devastating power of weaponry, and the strategic maneuvers that determine victory or defeat. From tank battles to secret vaults of apocalyptic weapons, the series delves into the minds of those who fight, sacrifice, and innovate in the most extreme circumstances. "War Chronicles" is a gripping exploration of human courage, technological evolution, and the relentless quest for survival in the theater of war. 🔥⚔️🚀',
                'trailer_url_type' => 'YouTube',
                'type' => 'tvshow',
                'trailer_url' => 'https://youtu.be/f6KdMY08WkU?si=xQSRjml8PcX3l_1Z',
                'movie_access' => 'free',
                'plan_id' => null,
                'status' => 1,
                'language' => 'hindi',
                'IMDb_rating' => 8,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '05:40',
                'release_date' => '2024-03-16',
                'is_restricted' => false,
                'created_by' => 1,
                'updated_by' => 1,
                'genre_id' => [1,3,5],
                'actors' =>[1,2,5,6,7,10,11,12,13,14,15,16,17],
                'directors' => [24,25,26,27,28,29,30,31,32,34,36,37,38,40],
                'countries' => [221],
            ],
            [
                'name' => 'Journey to the Core',
                'thumbnail_url' => '/dummy-images/entertainment/tvshow/thumb/journey_to_the_core_thumb.png',
                'poster_url' => '/dummy-images/entertainment/tvshow/poster/journey_to_the_core_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/tvshow/thumb/journey_to_the_core_thumb.png',
                'description' => '"Journey to the Core" is a thrilling action-packed TV series that follows a group of elite scientists and adventurers as they embark on a perilous mission to explore the depths of the Earth. What begins as a scientific endeavor quickly turns into a fight for survival as they encounter ancient civilizations, powerful forces, and hidden dangers buried within the Earth\'s core. With the fate of humanity hanging in the balance, the team must band together to face challenges that could change the course of history. This show weaves together elements of discovery, intense action, and the clash of empires in a breathtaking journey that pushes the limits of human endurance and ingenuity. 🌋⚔️🔍',
                'trailer_url_type' => 'YouTube',
                'type' => 'tvshow',
                'trailer_url' => 'https://youtu.be/XI8uxmTSBWo?si=U5qJDxWja_3l4Vp9',
                'movie_access' => 'paid',
                'plan_id' => 1,
                'status' => 1,
                'language' => 'english',
                'IMDb_rating' => 9,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '05:31',
                'release_date' => '2024-04-13',
                'is_restricted' => false,
                'created_by' => 1,
                'updated_by' => 1,
                'genre_id' => [1,3,5],
                'actors' =>  [2,3,4,8,9,10,13,14,16,18,19,20],
                'directors' => [21,23,24,26,28,30,32,34,35,36,37,38,39,40],
                'countries' => [200,100],
            ],
            [
                'name' => 'Snip & Spy: The Cutthroat Mission',
                'thumbnail_url' => '/dummy-images/entertainment/tvshow/thumb/snip_spy_the_cutthroat_mission_thumb.png',
                'poster_url' => '/dummy-images/entertainment/tvshow/poster/snip_spy_the_cutthroat_mission_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/tvshow/thumb/snip_spy_the_cutthroat_mission_thumb.png',
                'description' => '"Snip & Spy: The Cutthroat Mission" is a thrilling blend of action, espionage, and comedy, centered around Ethan, a former elite special ops agent who has swapped guns for scissors. Now living a peaceful life as a barber, Ethan\'s world is turned upside down when his old enemy resurfaces, using his barbershop as a front for a deadly arms deal. Armed with his wit, barber tools, and quick reflexes, Ethan must battle waves of ruthless criminals while protecting his clients and his shop. As secrets unravel with each snip of his scissors, Ethan finds himself thrust back into the chaotic world of espionage where every haircut could be his last. Filled with explosive action and unexpected twists, this series is a hair-raising ride. ✂️💈💥🕶️',
                'trailer_url_type' => 'YouTube',
                'type' => 'tvshow',
                'trailer_url' => 'https://youtu.be/eH7EyPs_Va8?si=BRcgB15dMbdoEj7G',
                'movie_access' => 'paid',
                'plan_id' => 3,
                'status' => 1,
                'language' => 'english',
                'IMDb_rating' => null,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '05:25',
                'release_date' => '2024-04-28',
                'is_restricted' => false,
                'created_by' => 1,
                'updated_by' => 1,
                'genre_id' => [3,4,2],
                'actors' => [1,3,4,5,6,7,9,10,11,12,15,16,17],
                'directors' => [22,24,25,27,29,31,32,33,34,35,36,37],
                'countries' => [99,199],
            ],
            [
                'name' => 'Road to Reconnection',
                'thumbnail_url' => '/dummy-images/entertainment/tvshow/thumb/road_to_reconnection_thumb.png',
                'poster_url' => '/dummy-images/entertainment/tvshow/poster/road_to_reconnection_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/tvshow/thumb/road_to_reconnection_thumb.png',
                'description' => 'June Stevenson embarks on a deeply emotional and humorous road trip along the Pacific Coast, dragging her estranged sisters along to make amends with their difficult father. What starts as a trip full of distractions—picturesque landmarks, craft breweries, and charming men—soon reveals the hidden truths behind their family’s distance. With each stop, June uncovers more about her siblings, herself, and the complex web of love, regret, and misunderstandings that have kept them apart for years. "Road to Reconnection" is an inspirational story of family, healing, and the rocky but rewarding path to forgiveness. 🌟❤️🌊',
                'trailer_url_type' => 'YouTube',
                'type' => 'tvshow',
                'trailer_url' => 'https://youtu.be/AW0A_VE245c?si=msNsH9EnTnvesnDH',
                'movie_access' => 'free',
                'plan_id' => null,
                'status' => 1,
                'language' => 'english',
                'IMDb_rating' => null,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '06:50',
                'release_date' => '2024-05-02',
                'is_restricted' => false,
                'created_by' => 1,
                'updated_by' => 1,
                'genre_id' => [6,1,7],
                'actors' =>[3,4,5,6,7,8,10,11,14,15,16,17,18],
                'directors' => [23,24,25,26,27,28,30,32,33,34,35,36,37,39],
                'countries' => [9,19,29],
            ],
            [
                'name' => 'McDoll Mayhem',
                'thumbnail_url' => '/dummy-images/entertainment/tvshow/thumb/mcdoll_mayhem_thumb.png',
                'poster_url' => '/dummy-images/entertainment/tvshow/poster/mcdoll_mayhem_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/tvshow/thumb/mcdoll_mayhem_thumb.png',
                'description' => 'David McDoll’s lavish life turns uproarious when his six rambunctious grandchildren shake up his world, leading to a comedy of errors and heartfelt moments. 🏰👶😂',
                'trailer_url_type' => 'YouTube',
                'type' => 'tvshow',
                'trailer_url' => 'https://youtu.be/skl7gYRZHwE?si=kiekCHcihmEJH54D',
                'movie_access' => 'free',
                'plan_id' => null,
                'status' => 1,
                'language' => 'english',
                'IMDb_rating' => null,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '08:30',
                'release_date' => '2024-06-21',
                'is_restricted' => false,
                'created_by' => 1,
                'updated_by' => 1,
                'genre_id' => [3,5,7],
                'actors' => [1,2,3,4,8,9,10,11,13,14,16,19,20],
                'directors' => [24,25,26,27,28,29,30,31,32,34,36,37,38,40],
                'countries' => [8,18,28],
            ],
            [
                'name' => 'Enigma of the Heart',
                'thumbnail_url' => '/dummy-images/entertainment/tvshow/thumb/enigma_of_the_heart_thumb.png',
                'poster_url' => '/dummy-images/entertainment/tvshow/poster/enigma_of_the_heart_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/tvshow/thumb/enigma_of_the_heart_thumb.png',
                'description' => 'A high-profile celebrity journalist with a notorious reputation for fast flings and superficial romances meets his match in a stunning model who harbors secrets of her own. Drawn into her mysterious world, he’s forced to confront his own past choices, questioning the life he’s been leading. As they navigate their complicated relationship, their hearts begin to unravel hidden truths, ultimately showing them that love is more powerful—and more complex—than either of them had ever anticipated. This captivating love story is one of redemption, transformation, and the search for true meaning in life and love. 💘✨💑',
                'trailer_url_type' => 'YouTube',
                'type' => 'tvshow',
                'trailer_url' => 'https://youtu.be/rS15OQLyWIs?si=9TIyww8T6LJCFSrr',
                'movie_access' => 'paid',
                'plan_id' => 1,
                'status' => 1,
                'language' => 'english',
                'genre_id' => [7,5,6,8],
                'IMDb_rating' => null,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '09:20',
                'release_date' => '2024-07-10',
                'is_restricted' => false,
                'created_by' => 1,
                'updated_by' => 1,
                'actors' => [2,5,6,7,9,11,12,13,15,16,17,18],
                'directors' => [21,22,25,26,27,28,29,30,34,35,36,39,40],
                'countries' => [7,17,27,37],
            ],
            [
                'name' => 'The Reckoning of Blackthorn',
                'thumbnail_url' => '/dummy-images/entertainment/tvshow/thumb/the_reckoning_of_blackthorn_thumb.png',
                'poster_url' => '/dummy-images/entertainment/tvshow/poster/the_reckoning_of_blackthorn_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/tvshow/thumb/the_reckoning_of_blackthorn_thumb.png',
                'description' => '"The Reckoning of Blackthorn" follows Father James, a Catholic priest whose faith has been shattered by a tragic event he could not prevent—a young girl’s suicide. Months after her death, he is drawn back to Blackthorn Manor, the abandoned mansion where she took her life. Trapped in the mansion overnight, James begins to believe that the ghosts of the girl and her stepfather have returned from the grave to demand retribution. As he faces these vengeful spirits and his inner demons, James embarks on a harrowing journey for redemption, battling forces both supernatural and psychological in a race against time. This thrilling show explores themes of guilt, redemption, and the darkness that can lurk in one’s soul. 👻🏚️🩸',
                'trailer_url_type' => 'YouTube',
                'type' => 'tvshow',
                'trailer_url' => 'https://youtu.be/bvDArsKoTOE?si=2wx6GVga2c-afd7y',
                'movie_access' => 'paid',
                'plan_id' => 1,
                'status' => 1,
                'language' => 'english',
                'genre_id' => [8,1,2,4],
                'IMDb_rating' => null,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '08:10',
                'release_date' => '2024-08-12',
                'is_restricted' => false,
                'created_by' => 1,
                'updated_by' => 1,
                'actors' => [1,2,4,6,7,10,11,12,13,14,15,16,17],
                'directors' => [22,23,25,28,29,30,31,33,34,36,37,39,40],
                'countries' => [47,57,67],
            ],
            [
                'name' => 'Heritage Hijinks',
                'thumbnail_url' => '/dummy-images/entertainment/tvshow/thumb/heritage_hijinks_thumb.png',
                'poster_url' => '/dummy-images/entertainment/tvshow/poster/heritage_hijinks_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/tvshow/thumb/heritage_hijinks_thumb.png',
                'description' => 'The life of an African American college student who has been raised by a progressive white family. As he begins to question his cultural identity, he embarks on a comical and heartfelt journey with the help of his well-meaning white best friend. Together, they navigate the awkward, humorous, and often chaotic situations that arise when their families, with contrasting beliefs, come face to face. From navigating cultural misunderstandings to unearthing the meaning of family, this comedy is a funny yet poignant exploration of identity, self-acceptance, and the beauty of embracing one’s roots. 🌍🎉👫',
                'trailer_url_type' => 'YouTube',
                'type' => 'tvshow',
                'trailer_url' => 'https://youtu.be/WXpBN_31-Cw?si=xg1UJ2J5chVUWHdY',
                'movie_access' => 'free',
                'plan_id' => null,
                'status' => 1,
                'language' => 'english',
                'genre_id' => [3,5,7,6],
                'IMDb_rating' => null,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '06:45',
                'release_date' => '2024-09-05',
                'is_restricted' => false,
                'created_by' => 1,
                'updated_by' => 1,
                'actors' => [2,3,5,8,9,10,13,14,16,18,19,20],
                'directors' => [23,24,25,26,28,29,30,32,33,34,35,36,37,39],
                'countries' => [177,167,157],
            ],
            [
                'name' => 'Evil Awakening',
                'thumbnail_url' => '/dummy-images/entertainment/tvshow/thumb/evil_awakening_thumb.png',
                'poster_url' => '/dummy-images/entertainment/tvshow/poster/evil_awakening_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/tvshow/thumb/evil_awakening_thumb.png',
                'description' => 'A group of friends stumbles upon a mysterious and cursed relic, unleashing ancient evil forces upon the unsuspecting city. What begins as a casual discovery quickly spirals into terror as flesh-possessing demons wreak havoc, targeting anyone in their path. This gripping horror series pits the group against unimaginable horrors, as they must fight for their lives while uncovering dark secrets about the relic\'s origins. Estranged sisters and friends will have to confront their pasts, band together, and face their worst fears in a desperate battle for survival. With each episode unraveling new mysteries and terrifying encounters, "Evil Awakening" brings relentless scares and intense thrills to the screen. 😱🏙️',
                'trailer_url_type' => 'YouTube',
                'type' => 'tvshow',
                'trailer_url' => 'https://youtu.be/6LiKKFZyhRU?si=1al4KGEcQdP3LTQ1',
                'movie_access' => 'free',
                'plan_id' => null,
                'status' => 1,
                'language' => 'english',
                'genre_id' => [5,6,8,1],
                'IMDb_rating' => null,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '05:50',
                'release_date' => '2024-09-26',
                'is_restricted' => false,
                'created_by' => 1,
                'updated_by' => 1,
                'actors' => [1,3,4,5,6,7,9,10,11,12,15,16,17],
                'directors' =>[21,22,25,26,27,28,29,30,34,35,36,39,40],
                'countries' => [197],
            ],
            [
                'name' => 'The Forsaken Cabin',
                'thumbnail_url' => '/dummy-images/entertainment/tvshow/thumb/the_forsaken_cabin_thumb.png',
                'poster_url' => '/dummy-images/entertainment/tvshow/poster/the_forsaken_cabin_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/tvshow/thumb/the_forsaken_cabin_thumb.png',
                'description' => 'Four estranged friends—Esme, Hannah, Ben, and Shan—come together for a weekend of relaxation in a secluded cabin. But as they settle in, strange events begin to unfold, hinting that they are not alone. Their once peaceful retreat becomes a nightmare when they discover an ancient, malevolent force stalking them in the wilderness. As fear grips the group, hidden secrets from their past emerge, causing rifts in their friendship and forcing them to confront not only the evil outside but also the darkness within. Each episode intensifies the tension as the friends fight to escape the clutches of both supernatural horrors and their own buried regrets. 🕵️‍♀️🌲',
                'trailer_url_type' => 'YouTube',
                'type' => 'tvshow',
                'trailer_url' => 'https://youtu.be/O9i2vmFhSSY?si=YYmzH5_dw63-BeNU',
                'movie_access' => 'free',
                'plan_id' => null,
                'status' => 1,
                'language' => 'english',
                'genre_id' => [8,6,5],
                'IMDb_rating' => null,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '05:40',
                'release_date' => '2024-10-16',
                'is_restricted' => false,
                'created_by' => 1,
                'updated_by' => 1,
                'actors' => [2,5,6,7,9,11,12,13,15,16,17,18],
                'directors' => [22,23,25,28,29,30,31,33,34,36,37,39,40],
                'countries' => [187,137],
            ],



            //...............movie data....................

            [
                'name' => 'Operation Viper',
                'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/operation_viper_thumb.png',
                'poster_url' => '/dummy-images/entertainment/movie/poster/operation_viper_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/operation_viper_thumb.png',
                'description' => 'A covert team embarks on a high-stakes mission to thwart a dangerous terrorist organization. With explosive action and intense suspense, the team must navigate deadly traps and uncover hidden secrets to save the world from imminent catastrophe. 💥🔍',
                'trailer_url_type' => 'YouTube',
                'type' => 'movie',
                'trailer_url' => 'https://youtu.be/5zSPGLoN9lQ?si=vIAtP5OnEQ4gnMV8',
                'movie_access' => 'free',
                'status' => 1,
                'language' => 'english',
                'IMDb_rating' => 6.2,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '03:00',
                'release_date' => '2010-04-23',
                'is_restricted' => false,
                'created_by' => 1,
                'updated_by' => 1,
                'genre_id' => [1,2,3],
                'actors' => [1,2,3,8,9,10,13,14,15,18,20],
                'directors' => [21,23,24,26,28,30,32,34,35,36,37,38,39,40],
                'countries' => [1,100,225,91],
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/WVDNqc3TUVQ?si=osLuuOFoALDKcKEJ',
                'enable_quality' => 1,
                'stream_content' => [
                    [
                        'quality' => '480p',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/5zSPGLoN9lQ?si=-BRLpMNIEJrnKm6f',
                    ],
                    [
                        'quality' => '720p',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/5zSPGLoN9lQ?si=sygr-NcCZcS00O0p',
                    ],
                    [
                        'quality' => '1080p',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/5zSPGLoN9lQ?si=eckyQwNdCsW6Pao6',
                    ],
                    [
                        'quality' => '2K',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/5zSPGLoN9lQ?si=eckyQwNdCsW6Pao6',
                    ],
                ],
            ],
            [
                'name' => 'The Cure: Final Redemption',
                'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/the_cure_final_redemption_thumb.png',
                'poster_url' => '/dummy-images/entertainment/movie/poster/the_cure_final_redemption_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/the_cure_final_redemption_thumb.png',
                'description' => 'A team of elite agents races against time to uncover a deadly conspiracy, where the cure for a global pandemic holds the key to humanity\'s survival. As they navigate through treacherous terrain and face formidable foes, they must decide who to trust and how far they are willing to go to secure The Cure. 🌍💉',
                'trailer_url_type'=> 'YouTube',
                'type'=>'movie',
                'trailer_url' => 'https://youtu.be/eg8HPCKz6Rk?si=xDPYMcHMHIuLaJJn',
                'movie_access' => 'paid',
                'plan_id' => 2,
                'status' => 1,
                'language' => 'english',
                'IMDb_rating' => 7.5,
                'content_rating' => 'PG-13',
                'duration' => '02:45',
                // 'release_date' => '2011-01-12',
                'release_date' => Carbon::today()->addDays(rand(1, 30)),
                'is_restricted' => false,
                'created_by' => 1,
                'updated_by' => 1,
                'genre_id' => [1,4,5],
                'actors' => [4,5,6,7,11,12,13,16,17,19,20],
                'directors' =>[22,24,25,27,29,31,32,33,34,35,36,37],
                'countries' => [1,100,225],
                'video_upload_type'=> 'YouTube',
                'video_url_input'=>'https://youtu.be/PdxPlbKFkaM?si=H_nwgJKc4Ioqj1tR',
                'enable_quality' => 1,
                'stream_content' => [
                    [
                        'quality' => '480p',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/PdxPlbKFkaM?si=NydEmXECOvT1blJL',
                    ],
                    [
                        'quality' => '720p',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/PdxPlbKFkaM?si=zaa1bCmFWRbSxZEB',
                    ],
                    [
                        'quality' => '1080p',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/PdxPlbKFkaM?si=zlHHbalMgDJWz9Tp',
                    ],
                    [
                        'quality' => '2K',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/PdxPlbKFkaM?si=qaZ1H82OVU3sVx0V',
                    ],
                ],
            ],
            [
                'name' => 'The Gunfighter\'s Redemption',
                'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/the_gunfighters_redemption_thumb.webp',
                'poster_url' => '/dummy-images/entertainment/movie/poster/the_gunfighters_redemption_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/the_gunfighters_redemption_thumb.webp',
                'description' => 'A retired gunslinger is forced back into action when his peaceful life is shattered by ruthless outlaws. He must confront his past and fight for justice one last time. 🤠🔫',
                'trailer_url_type'=> 'YouTube',
                'type'=>'movie',
                'trailer_url' => 'https://youtu.be/ob8iKn-gLFI?si=sUpU_bMpIDocTFZ6',
                'movie_access' => 'free',
                'status' => 1,
                'language' => 'english',
                'IMDb_rating' => 6,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '02:30',
                'release_date' => '2012-03-08',
                'is_restricted' => false,
                'created_by' => 1,
                'updated_by' => 1,
                'genre_id' => [1,5,6],
                'actors' => [1,3,4,5,6,8,10,11,12,13,14,17,18],
                'directors' =>[24,25,26,27,28,29,30,31,32,34,36,37,38,40],
                'countries' => [126,226],
                'video_upload_type'=> 'YouTube',
                'video_url_input'=>'https://youtu.be/TXfltmzRG-g?si=l0bYn4q-22XCmsJy'
            ],
            [
                'name' => 'Daizy\'s Enchanted Journey',
                'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/daizys_enchanted_journey_thumb.webp',
                'poster_url' => '/dummy-images/entertainment/movie/poster/daizys_enchanted_journey_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/daizys_enchanted_journey_thumb.webp',
                'description' => 'Join Daizy on an enchanting adventure as she discovers the world beyond her tower. With her magical hair and unwavering spirit, she teams up with a charming rogue and a cast of quirky characters to uncover the secrets of her past and embrace her destiny. This heartwarming tale of bravery, friendship, and self-discovery will captivate audiences of all ages. 🌟🧚‍♀️',
                'trailer_url_type'=> 'YouTube',
                'type'=>'movie',
                'trailer_url' => 'https://youtu.be/1c3O3-sVFC0?si=p7TI-JkU7E5LB5HJ',
                'movie_access' => 'free',
                'status' => 1,
                'language' => 'english',
                'IMDb_rating' => 7.1,
                'content_rating' => 'PG (Parental Guidance Suggested)',
                'duration' => '03:06',
                'release_date' => '2014-07-06',
                'is_restricted' => true,
                'created_by' => 1,
                'updated_by' => 1,
                'genre_id' => [2,4,5],
                'actors' =>[2,4,7,8,9,12,13,14,15,16,19,20],
                'directors' => [21,22,25,26,27,28,29,30,34,35,36,39,40],
                'countries' => [26,46],
                'video_upload_type'=> 'YouTube',
                'video_url_input'=>'https://youtu.be/aGjRYObE5Vw?si=7Q99VNk-J4Q5yWAC'
            ],
            [
                'name' => 'Secrets of Zambezia',
                'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/secrets_of_zambezia_thumb.png',
                'poster_url' => '/dummy-images/entertainment/movie/poster/secrets_of_zambezia_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/secrets_of_zambezia_thumb.png',
                'description' => 'In Secrets of Zambezia, a spirited young falcon named Kai leaves his remote outpost to explore Zambezia, a majestic city hidden in the heart of Africa. Here, he discovers a vibrant community of birds from all over the world, each with their own unique talents and traditions. As Kai learns about friendship, courage, and the importance of diversity, he uncovers ancient secrets that could change Zambezia forever. Filled with stunning animation and heartwarming moments, this adventure will enchant audiences of all ages. 🌍🦅',
                'trailer_url_type'=> 'YouTube',
                'type'=>'movie',
                'trailer_url' => 'https://youtu.be/gxslnpqFwOs?si=fRi0Wnbd4qUCw43i',
                'movie_access' => 'free',
                'status' => 1,
                'language' => 'english',
                'IMDb_rating' => 7.5,
                'content_rating' => 'PG (Parental Guidance Suggested)',
                'duration' => '02:15',
                'release_date' => '2016-06-04',
                'is_restricted' => true,
                'created_by' => 1,
                'updated_by' => 1,
                'genre_id' => [2,8,9],
                'actors' => [3,5,6,7,8,9,10,11,12,16,17,18],
                'directors' => [22,23,25,28,29,30,31,33,34,36,37,39,40],
                'countries' => [221,101],
                'video_upload_type'=> 'YouTube',
                'video_url_input'=>'https://youtu.be/qWCKqFWPjAY?si=a2c6hq4yTIKlYFJ4'
            ],
            [
                'name' => 'The New Empire',
                'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/the_new_empire_thumb.png',
                'poster_url' => '/dummy-images/entertainment/movie/poster/the_new_empire_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/the_new_empire_thumb.png',
                'description' => 'The New Empire brings an exhilarating clash of the titans, where Godzilla and Kong must join forces to defend their realm against an unprecedented threat. In this animated adventure, the balance of power shifts as a new, formidable adversary emerges, threatening to plunge their world into chaos. With stunning visuals and heart-pounding action, "The New Empire" explores themes of unity, courage, and the primal struggle for survival. Join Godzilla and Kong on a journey filled with breathtaking battles, unexpected alliances, and the ultimate test of strength and resilience. 🌍🦖🦍',
                'trailer_url_type'=> 'YouTube',
                'type'=>'movie',
                'trailer_url' => 'https://youtu.be/jSGlwLzjHpI?si=le4MKsQdLAyXjTpm',
                'movie_access' => 'paid',
                'plan_id' => 2,
                'status' => 1,
                'language' => 'english',
                'IMDb_rating' => 9.1,
                'content_rating' => 'PG (Parental Guidance Suggested)',
                'duration' => '03:56',
                'release_date' => '2017-08-14',
                'is_restricted' => true,
                'created_by' => 1,
                'updated_by' => 1,
                'genre_id' => [2,5,6],
                'actors' =>[1,2,4,8,11,12,13,14,15,19,20],
                'directors' => [23,24,25,26,28,29,30,32,33,34,35,36,37,39],
                'countries' => [101,212,220],
                'video_upload_type'=> 'YouTube',
                'video_url_input'=>'https://youtu.be/hlKFxyxOWIQ?si=Avo5stG4_o4UiUOe',
                'enable_quality' => 1,
                'stream_content' => [
                    [
                        'quality' => '480p',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/hlKFxyxOWIQ?si=d5nuCs6BYaIZJhSn',
                    ],
                    [
                        'quality' => '720p',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/hlKFxyxOWIQ?si=0NmD4yAoShQigs07',
                    ],
                    [
                        'quality' => '1080p',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/hlKFxyxOWIQ?si=_KagBhO3OxIJxdyx',
                    ],
                    [
                        'quality' => '1440p',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/hlKFxyxOWIQ?si=H096nrbHzq3_2hWF',
                    ],
                ],
            ],
            [
                'name' => 'The Daring Player',
                'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/the_daring_player_thumb.webp',
                'poster_url' => '/dummy-images/entertainment/movie/poster/the_daring_player_poster.png',
                'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/the_daring_player_thumb.webp',
                'description' => 'The Daring Playe is a comedic tale of an intrepid athlete with a knack for finding himself in the most absurd and laugh-inducing predicaments. With a heart full of courage and a head full of unconventional ideas, our hero tackles everything from high-stakes competitions to everyday mishaps. Along the way, he encounters a quirky cast of characters who add to the chaos and fun. Packed with laughter, excitement, and heartwarming moments, this movie is a delightful journey through the world of a true daredevil. 🏅🤣',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => 'https://youtu.be/OPQogQKVeTk?si=YOmW1cKIiWOZqq34',
                'movie_access' => 'paid',
                'plan_id' => 3,
                'status' => 1,
                'language' => 'hindi',
                'genre_id' => [3,5],
                'IMDb_rating' => 6.5,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '02:50',
                'release_date' => '2019-03-07',
                'is_restricted' => false,
                'actors' => [2,5,6,7,9,11,12,13,15,16,17,18],
                'directors' => [21,24,25,26,27,28,29,30,34,35,36,39,40],
                'countries' => [221,227,117,37],
                'type' => 'movie',
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/U-KfnCpEEl4?si=fQOoRWLbiIVBaL1k',
                'enable_quality' => 1,
                'stream_content' => [
                    [
                        'quality' => '480p',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/U-KfnCpEEl4?si=Vc70N3_zFcBD0yR4',
                    ],
                    [
                        'quality' => '720p',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/U-KfnCpEEl4?si=HUmROBp9MupZ_mAa',
                    ],
                    [
                        'quality' => '1080p',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/U-KfnCpEEl4?si=Wd3qSh7kodL-LvxC',
                    ],
                    [
                        'quality' => '1440p',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/U-KfnCpEEl4?si=QcjXOGpAHgsq1IJl',
                    ],
                ],
            ],
            [
                'name' => 'The Monkey King: Kingdom of Shadows',
                'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/the_monkey_king_kingdom_of_shadows_thumb.png',
                'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/the_monkey_king_kingdom_of_shadows_thumb.png',
                'poster_url' => '/dummy-images/entertainment/movie/poster/the_monkey_king_kingdom_of_shadows_poster.png',
                'description' => 'The Monkey King: Kingdom of Shadows" follows the legendary Monkey King as he faces his greatest challenge yet. When an ancient evil emerges, casting a dark shadow over his kingdom, the Monkey King must summon all his strength and cunning to protect his realm. Alongside a band of loyal companions, he ventures into treacherous territories, confronts formidable enemies, and uncovers hidden secrets. This gripping thriller blends epic battles with supernatural intrigue, delivering a heart-pounding adventure that will keep audiences on the edge of their seats. 🐒⚔️🌑',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => 'https://youtu.be/Ssu5XsVngDI?si=le5P47hemzqTawW4',
                'movie_access' => 'paid',
                'plan_id' => 2,
                'status' => 1,
                'language' => 'hindi',
                'genre_id' => [8,6,7],
                'IMDb_rating' => 8.5,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '02:55',
                'release_date' => '2020-01-10',
                'is_restricted' => false,
                'actors' => [1,2,3,4,8,9,10,11,13,14,16,19,20],
                'directors' => [22,23,24,28,29,30,31,32,34,36,37,38,40],
                'countries' => [154,174,24,34],
                'type' => 'movie',
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/7QbM6edqrr8?si=cxJkQJPoga1k3GBH'
            ],
            [
                'name' => 'Deep Sea Mysteries',
                'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/deep_sea_mysteries_thumb.png',
                'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/deep_sea_mysteries_thumb.png',
                'poster_url' => '/dummy-images/entertainment/movie/poster/deep_sea_mysteries_poster.png',
                'description' => 'In Deep Sea Mysteries, an elite team of scientists and explorers embarks on a high-stakes underwater expedition to uncover the ocean\'s most guarded secrets. As they venture deeper into uncharted territories, they encounter breathtaking wonders and formidable creatures. However, the thrill of discovery quickly turns into a fight for survival as they stumble upon a long-lost civilization\'s dark secrets. With danger lurking at every turn, the team must navigate treacherous waters, solve ancient puzzles, and confront their deepest fears to unravel the mysteries of the deep sea. This thrilling adventure is a gripping tale of courage, discovery, and the relentless pursuit of truth. 🌊🦈⚓',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => 'https://youtu.be/WwSsikrAN-E?si=0G6UPDm-H7LW3Not',
                'movie_access' => 'paid',
                'plan_id' => 3,
                'status' => 1,
                'language' => 'hindi',
                'genre_id' => [8,6,5],
                'IMDb_rating' => 8.8,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '01:50',
                'release_date' => '2020-03-15',
                'is_restricted' => false,
                'actors' => [2,5,6,7,9,11,12,13,15,16,17,18],
                'directors' => [23,24,25,26,27,28,30,32,33,34,35,36,37,39],
                'countries' => [244],
                'type' => 'movie',
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/so2XtxcSLHQ?si=3AkAW4QC9aZOpGKA',
                'enable_quality' => 1,
                'stream_content' => [
                    [
                        'quality' => '480p',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/so2XtxcSLHQ?si=ac0V29WoRwQyTNc7',
                    ],
                    [
                        'quality' => '720p',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/so2XtxcSLHQ?si=N97AW29RFILE1nZ0',
                    ],
                    [
                        'quality' => '1080p',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/so2XtxcSLHQ?si=yk7Cvs-MlKkT8MQy',
                    ],

                ],
            ],
            [
                'name' => 'The Wacky Adventures of Tim and Tom',
                'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/the_wacky_adventures_of_tim_and_tom_thumb.png',
                'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/the_wacky_adventures_of_tim_and_tom_thumb.png',
                'poster_url' => '/dummy-images/entertainment/movie/poster/the_wacky_adventures_of_tim_and_tom_poster.png',
                'description' => 'Get ready for non-stop laughter with "The Wacky Adventures of Tim and Tom." This comedy movie follows two lifelong friends, Tim and Tom, whose penchant for wild schemes and hilarious mishaps constantly lands them in the most outrageous situations. Whether they\'re attempting to start a dubious business, navigating the pitfalls of modern dating, or embarking on a spontaneous road trip, their friendship is the one constant that keeps them grounded amidst the chaos. With a mix of slapstick humor, witty dialogue, and heartwarming moments, "The Wacky Adventures of Tim and Tom" is a feel-good film that celebrates the enduring power of friendship and the joy of embracing life\'s unpredictability. Join Tim and Tom on their laugh-out-loud journey where every day is a new adventure filled with endless comedy. 😂🚗🍿',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => 'https://youtu.be/Mmq_NVwLN_g?si=JfALgqlfHlZgaoZP',
                'movie_access' => 'free',
                'status' => 1,
                'language' => 'english',
                'genre_id' => [3,7,5],
                'IMDb_rating' => 7,
                'content_rating' => 'PG (Parental Guidance Suggested)',
                'duration' => '02:40',
                // 'release_date' => '2020-03-01',
                'release_date' => Carbon::today()->addDays(rand(1, 30)),
                'is_restricted' => false,
                'actors' =>[1,2,4,6,7,10,11,12,13,14,15,16,17],
                'directors' =>[24,25,26,27,28,29,30,31,32,34,36,37,38,40],
                'countries' => [144,156],
                'type' => 'movie',
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/dXiLaNVaRyw?si=an3a6I7K8ocDdA-A'
            ],
            [
                'name' => 'Laugh Out Loud',
                'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/laugh_out_loud_thumb.png',
                'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/laugh_out_loud_thumb.png',
                'poster_url' => '/dummy-images/entertainment/movie/poster/laugh_out_loud_poster.png',
                'description' => 'Follow the uproarious escapades of a group of mismatched friends as they navigate life\'s absurdities. From wild parties to chaotic road trips, their misfortunes and misunderstandings lead to a series of laugh-out-loud moments. With each friend bringing their own quirky personality to the mix, they find themselves in hilariously unpredictable situations. Through it all, their camaraderie and the power of laughter keep them together, reminding us that sometimes the best way to handle life\'s challenges is to just laugh out loud. 😂🚗🌟',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => 'https://youtu.be/fEzWvEoD9ew?si=YNoDNhX0EOQ4oXsH',
                'movie_access' => 'free',
                'status' => 1,
                'language' => 'english',
                'genre_id' => [3,7,5],
                'IMDb_rating' => 9,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '02:35',
                'release_date' => '2020-04-04',
                'is_restricted' => false,
                'actors' => [2,3,5,8,9,10,13,14,16,18,19,20],
                'directors' => [21,23,24,26,28,30,32,34,35,36,37,38,39,40],
                'countries' => [177,58],
                'type' => 'movie',
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/zW3f0TYKJqw?si=X2K5WpJXtcS_6Pav'
            ],
            [
                'name' => 'Frank and Fearless Adventures',
                'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/frank_and_fearless_adventures_thumb.png',
                'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/frank_and_fearless_adventures_thumb.png',
                'poster_url' => '/dummy-images/entertainment/movie/poster/frank_and_fearless_adventures_poster.png',
                'description' => 'Frank and Fearless Adventures is a heartwarming and hilarious family comedy that follows the unlikely duo of Frank, a bumbling but lovable inventor, and Fearless, a daring young adventurer with a knack for getting into trouble. Together, they embark on a series of misadventures that take them from their quiet hometown to the wilds of the jungle, the depths of the ocean, and even outer space. Along the way, they encounter quirky characters, outlandish obstacles, and plenty of laughs. With its blend of humor, excitement, and touching moments, "Frank and Fearless Adventures" is a feel-good film that promises to entertain audiences of all ages. 🌟😂🛠️',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => 'https://youtu.be/_8slPqV-16w?si=oCMjQ4pRqCEBc-fF',
                'movie_access' => 'free',
                'status' => 1,
                'language' => 'english',
                'genre_id' => [3,4,2],
                'IMDb_rating' => 6.7,
                'content_rating' => 'PG (Parental Guidance Suggested)',
                'duration' => '02:58',
                'release_date' => '2020-06-11',
                'is_restricted' => false,
                'actors' => [4,5,6,7,11,12,13,16,17,19,20],
                'directors' => [22,24,25,27,29,31,32,33,34,35,36,37],
                'countries' => [199,69],
                'type' => 'movie',
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/RnqIF9ZHxKk?si=CcqAkQHgZBnpZ9nC'
            ],
            [
                'name' => 'Haunting Shadows',
                'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/haunting_shadows_thumb.png',
                'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/haunting_shadows_thumb.png',
                'poster_url' => '/dummy-images/entertainment/movie/poster/haunting_shadows_poster.png',
                'description' => 'A bone-chilling horror movie, a group of investigators explores the dark and twisted history of an abandoned orphanage shrouded in mystery. As they uncover the sinister events that transpired within its walls, they encounter restless spirits and malevolent forces determined to keep their secrets hidden. Battling their own fears and the supernatural, they must find a way to escape before they become the next victims. "Haunting Shadows" delivers a harrowing and suspenseful experience that will leave viewers on the edge of their seats. 👻🏚️',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => 'https://youtu.be/_XV764KWBrA?si=dX3daijNvpduGGKR',
                'movie_access' => 'free',
                'status' => 1,
                'language' => 'english',
                'genre_id' => [5,4,2],
                'IMDb_rating' => 7.2,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '02:40',
                'release_date' => '2020-07-03',
                'is_restricted' => false,
                'actors' => [1,3,4,5,6,8,10,11,12,13,14,17,18],
                'directors' => [23,24,25,26,28,29,30,32,33,34,35,36,37,39],
                'countries' => [129,77],
                'type' => 'movie',
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/ATi3GdospAo?si=KVHj8EF_1AFOkci5'
            ],
            [
                'name' => 'Echoes of Terror',
                'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/echoes_of_terror_thumb.png',
                'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/echoes_of_terror_thumb.png',
                'poster_url' => '/dummy-images/entertainment/movie/poster/echoes_of_terror_poster.png',
                'description' => 'A spine-tingling horror movie, a once-peaceful town is haunted by a series of terrifying events linked to a dark and ancient curse. As a group of brave investigators unravels the sinister history behind the curse, they encounter vengeful spirits and malevolent forces. Battling their own fears and the supernatural, they must race against time to uncover the truth and put an end to the terror. "Echoes of Terror" is a harrowing journey into the unknown, filled with suspense and chilling moments that will leave viewers breathless. 😱👹',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => 'https://youtu.be/smTK_AeAPHs?si=UQAlhFHgP-j1YSjG',
                'movie_access' => 'free',
                'status' => 1,
                'language' => 'english',
                'genre_id' => [5,8,7],
                'IMDb_rating' => 7.5,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '02:50',
                'release_date' => '2021-07-08',
                'is_restricted' => false,
                'actors' => [2,4,7,8,9,12,13,14,15,16,19,20],
                'directors' => [21,22,25,26,27,28,29,30,34,35,36,39,40],
                'countries' => [48,12],
                'type' => 'movie',
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/wTGqBmUTCMQ?si=jTuwff4Q6CDdEN5H'


            ],
            [
                'name' => 'Origins of Civilization: The Dawn of Empires',
                'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/origins_civilization_thumb.png',
                'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/origins_civilization_thumb.png',
                'poster_url' => '/dummy-images/entertainment/movie/poster/origins_civilization_poster.png',
                'description' => 'Origins of Civilization: The Dawn of Empires is a captivating historical documentary that explores the emergence of the world\'s first great civilizations. Journey through ancient Mesopotamia, Egypt, the Indus Valley, and China as the film uncovers the remarkable innovations, cultural achievements, and pivotal moments that shaped human history. With stunning visuals and expert insights, this documentary brings to life the stories of the pioneering societies that laid the foundation for modern civilization. Discover how these ancient empires rose to greatness, overcame challenges, and left an enduring legacy that continues to influence our world today. 🌍🏛️',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => 'https://youtu.be/W0_55mECsa4?si=b_AlIpdvNC_wZ5Zr',
                'movie_access' => 'free',
                'status' => 1,
                'language' => 'english',
                'genre_id' => [4,6,8],
                'IMDb_rating' => 5.5,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '02:56',
                // 'release_date' => '2021-07-17',
                'release_date' => Carbon::today()->addDays(rand(1, 30)),
                'is_restricted' => false,
                'actors' => [1,2,4,8,11,12,13,14,15,19,20],
                'directors' => [22,23,25,28,29,30,31,33,34,36,37,39,40],
                'countries' => [224],
                'type' => 'movie',
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/7jbO8ToJTko?si=cHMWBfwPFObg3wma'
            ],
            [
                'name' => 'Legacy of Antiquity: Origins of Civilization',
                'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/legacy_of_antiquity_thumb.png',
                'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/legacy_of_antiquity_thumb.png',
                'poster_url' => '/dummy-images/entertainment/movie/poster/legacy_of_antiquity_poster.png',
                'description' => 'Legacy of Antiquity: Origins of Civilization is a comprehensive historical documentary that journeys back to the dawn of human civilization. From the ancient cities of Sumer and the monumental architecture of Egypt to the philosophical enlightenment of Greece and the engineering marvels of Rome, this film unravels the complex tapestry of early societies and their enduring legacies. Through expert analysis, immersive storytelling, and breathtaking visuals, uncover the cultural, political, and technological advancements that defined these pivotal periods in history. Legacy of Antiquity invites viewers to explore the origins of human achievement and the profound impact of ancient civilizations on our modern world. 🏛️🌍',
                'trailer_url_type' => 'YouTube',
                'trailer_url' => 'https://youtu.be/JZAkVbZVPTg?si=6ruDm6DJxmgWCnyJ',
                'movie_access' => 'free',
                'status' => 1,
                'language' => 'english',
                'genre_id' => [4,5],
                'IMDb_rating' => 7.5,
                'content_rating' => 'TV-MA (Mature Audiences)',
                'duration' => '02:45',
                'release_date' => '2022-07-24',
                'is_restricted' => false,
                'actors' =>[3,4,5,6,7,10,11,14,15,16,17,18],
                'directors' =>[23,24,25,26,27,28,30,32,33,34,35,36,37,39],
                'countries' => [268],
                'type' => 'movie',
                'video_upload_type' => 'YouTube',
                'video_url_input' => 'https://youtu.be/WltJPKFo_J4?si=L4BpLkhhHu3Yk5SS',
                'enable_quality' => 1,
                'stream_content' => [
                    [
                        'quality' => '480p',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/WltJPKFo_J4?si=zz4-zHhey7CK-d3N',
                    ],
                    [
                        'quality' => '720p',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/WltJPKFo_J4?si=0wIlovLv2RVlfjxt6',
                    ],
                    [
                        'quality' => '1080p',
                        'type' => 'YouTube',
                        'url' => 'https://youtu.be/WltJPKFo_J4?si=BvEAyAoOkOdLnFr4',
                    ],

                ]
            ],
                [
                    'name' => 'Rise Above',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/rise_above_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/rise_above_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/rise_above_poster.png',
                    'description' => 'In Rise Above, an inspirational short film, we follow the journey of a young individual who faces immense challenges and setbacks. Through determination, resilience, and the support of loved ones, they rise above adversity to achieve their dreams. This heartwarming and motivational story reminds us that no matter how difficult the path, success is within reach if we believe in ourselves and never give up. 🌟💪',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/4v7bSmTqx-Y?si=Oa05Nt5KpiD59vYN',
                    'movie_access' => 'free',
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [6,7,4],
                    'IMDb_rating' => 9,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:35',
                    'release_date' => '2023-08-04',
                    'is_restricted' => false,
                    'actors' => [1,3,4,8,9,10,11,13,14,16,19,20],
                    'directors' =>[24,25,26,27,28,29,30,31,32,34,36,37,38,40],
                    'countries' => [46,246],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/4v7bSmTqx-Y?si=hVcCSbCyThkDg503'
                ],

                [
                    'name' => 'A Journey of Triumph',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/a_journey_of_triumph_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/a_journey_of_triumph_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/a_journey_of_triumph_poster.png',
                    'description' => 'A Journey of Triumph is an uplifting and motivational film that chronicles the extraordinary stories of individuals who have faced insurmountable odds and emerged victorious. Through powerful narratives and moving testimonials, the film highlights the unwavering spirit, determination, and courage required to rise above adversity. With breathtaking visuals and heartfelt moments, A Journey of Triumph inspires viewers to believe in their own potential and strive for greatness, no matter the obstacles. 🌟💪',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/gJxRD-092rI?si=Yi-PuPoYEKRicQHv',
                    'movie_access' => 'free',
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [6,2,3],
                    'IMDb_rating' => 7.5,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '01:25',
                    'release_date' => '2023-08-10',
                    'is_restricted' => false,
                    'actors' => [2,5,6,7,9,11,12,13,15,16,17,18],
                    'directors' => [21,23,24,26,28,30,32,34,35,36,37,38,39,40],
                    'countries' => [222],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/6WxscBX09Xs?si=rDk_v2tbG_G0Yup7'
                ],

                [
                    'name' => 'Forever and a Day',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/forever_and_a_day_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/forever_and_a_day_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/forever_and_a_day_poster.png',
                    'description' => 'Forever and a Day is a captivating romantic film that tells the enchanting story of two souls destined to be together across lifetimes. When a modern-day writer discovers the love letters of a long-lost couple, she becomes entwined in their timeless romance. As their story unfolds, she embarks on a journey to find her own true love, realizing that some connections are meant to last forever. Filled with heartfelt moments, breathtaking scenery, and an unforgettable love story, "Forever and a Day" is a beautiful ode to enduring love. 💖⏳',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/NTAzn4W48gc?si=WCToq6upXzjdetux',
                    'movie_access' => 'free',
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [7,1,2],
                    'IMDb_rating' => 6.2,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '01:30',
                    'release_date' => '2024-04-04',
                    'is_restricted' => false,
                    'actors' => [1,2,3,8,9,10,13,14,15,18,20],
                    'directors' => [22,24,25,27,29,31,32,33,34,35,36,37],
                    'countries' => [169,78],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/KitwmpvZ2GU?si=0PZuT_sk6eTIDDkB'
                ],

                [
                    'name' => 'Forever in My Heart',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/forever_in_my_heart_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/forever_in_my_heart_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/forever_in_my_heart_poster.png',
                    'description' => 'Forever in My Heart tells the enchanting story of two soulmates whose love endures the test of time and distance. When Sarah and Michael meet, it\'s love at first sight, but life circumstances soon separate them. Despite the miles and years that come between them, their connection remains unbroken. Through letters, dreams, and unexpected reunions, they navigate life\'s challenges, always finding their way back to each other. This romantic tale is a celebration of enduring love, hope, and the belief that true love is forever. ❤️💑',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/p3PboMzVt8c?si=_tM07Z7p7k1LqjDH',
                    'movie_access' => 'free',
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [7,4,5],
                    'IMDb_rating' => 7.5,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:30',
                    'release_date' => '2024-05-11',
                    'is_restricted' => false,
                    'actors' =>[4,5,6,7,11,12,13,16,17,19,20],
                    'directors' => [23,24,25,26,27,28,30,32,33,34,35,36,37,39],
                    'countries' => [168,72],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/22l6w8n9iCc?si=u2fUQaTyOLUyTvhh',
                    'enable_quality' => 1,
                    'stream_content' => [
                        [
                            'quality' => '480p',
                            'type' => 'YouTube',
                            'url' => 'https://youtu.be/22l6w8n9iCc?si=ojEDxNeMZ9DEFg8J',
                        ],
                        [
                            'quality' => '720p',
                            'type' => 'YouTube',
                            'url' => 'https://youtu.be/22l6w8n9iCc?si=4gAqMfc4DUSUyg3G',
                        ],
                        [
                            'quality' => '1080p',
                            'type' => 'YouTube',
                            'url' => 'https://youtu.be/22l6w8n9iCc?si=gVdCokIa76dm3gJy',
                        ],

                    ],
                ],
                [
                    'name' => 'Milo\'s Ocean Adventure',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/milos_ocean_adventure_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/milos_ocean_adventure_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/milos_ocean_adventure_poster.png',
                    'description' => 'In the vibrant world beneath the waves, Milo, a curious young sea creature, sets off on an adventure to explore the ocean\'s wonders. Along the way, he meets new friends, faces exciting challenges, and uncovers hidden treasures. Together, they learn the power of friendship and courage, making this a heartwarming tale of discovery and bravery. 🌊🦑✨',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/mYfJxlgR2jw?si=3O8vMOR3lcDfwHqq',
                    'movie_access' => 'paid',
                    'plan_id' => 2,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [2,5,7],
                    'IMDb_rating' => null,
                    'content_rating' => 'PG (Parental Guidance Suggested)',
                    'duration' => '01:45',
                    'release_date' => '2024-05-16',
                    'is_restricted' => true,
                    'actors' => [1,2,4,8,11,12,13,14,15,19,20],
                    'directors' => [23,24,25,26,28,29,30,32,33,34,35,36,37,39],
                    'countries' => [18,49,167],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/lvIs63DE6aw?si=TKDAl1CbyDF8J6KJ'
                ],
                [
                    'name' => 'The Treasure of Zandara',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/the_treasure_of_zandara_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/the_treasure_of_zandara_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/the_treasure_of_zandara_poster.png',
                    'description' => 'Brave explorer Leo and spirited adventurer Kara embark on a daring mission to find Kara\'s missing father, an archaeologist who has vanished while seeking the fabled treasure of Zandara. Along their journey through enchanted jungles and ancient temples, they face mythical creatures, cunning foes, and wild adventures to unlock the secrets of the legendary treasure. 🗺️🐘🌿',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/TAFWnX6tsHg?si=u3UMgA6W8IT5WuN7',
                    'movie_access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [1,2,3],
                    'IMDb_rating' => null,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:00',
                    'release_date' => '2024-05-21',
                    'is_restricted' => false,
                   'actors' => [3,4,5,6,7,10,11,14,15,16,17,18],
                    'directors' => [21,22,25,26,27,28,29,30,34,35,36,39,40],
                    'countries' => [154,137],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/IUyHsIocEAg?si=4wMxTZXcE1CNZPVY'
                ],
                [
                    'name' => 'Braveheart of the Highlands',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/braveheart_of_the_highlands_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/braveheart_of_the_highlands_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/braveheart_of_the_highlands_poster.png',
                    'description' => 'Young Robert, a courageous warrior, finds himself injured and on the run from an invading army. Rescued by a humble family in the Highlands, he regains his strength and rallies his people to fight for the freedom of their beloved land. 🌄🛡️⚔️',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/LALlUFEGdeE?si=pG5fTkaYGyGBNMr2',
                    'movie_access' => 'paid',
                    'plan_id' => 2,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [4,5,6],
                    'IMDb_rating' => null,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:30',
                    'release_date' => '2024-05-22',
                    'is_restricted' => false,
                    'actors' => [9, 1, 10, 7, 11, 4, 12],
                    'directors' => [39, 24, 30, 33, 31, 38, 27],
                    'countries' => [125,197],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/6yenmPC1jOM?si=aSP5WLiBRmLuB1iJ'
                ],
                [
                    'name' => 'Spooky Roommate Ruckus',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/spooky_roommate_ruckus_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/spooky_roommate_ruckus_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/spooky_roommate_ruckus_poster.png',
                    'description' => 'A musician\'s quiet evening is turned upside down when his sleepwalking roommate begins unraveling the haunted house\'s eerie secrets. The film offers a comedic twist on ghostly encounters as the musician tries to manage both the spooky happenings and the humorous chaos caused by his sleepwalking roommate. It’s a laugh-out-loud comedy that mixes musical elements with supernatural shenanigans. 🎤🎃',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/2X7G6p-oNG8?si=Y2MRnmG1oRRQI0yV',
                    'movie_access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [7,8],
                    'IMDb_rating' => null,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '01:30',
                    'release_date' => '2024-05-24',
                    'is_restricted' => false,
                    'actors' => [1,3,4,8,9,10,11,13,14,16,19,20],
                    'directors' => [22,23,25,28,29,30,31,33,34,36,37,39,40],
                    'countries' => [197],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/SX1LiKN4ZcQ?si=6uJZt7OGt6EUzHD_'
                ],
                [
                   'name' => 'Run With Purpose',
                   'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/run_with_purpose_thumb.png',
                   'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/run_with_purpose_thumb.png',
                   'poster_url' => '/dummy-images/entertainment/movie/poster/run_with_purpose_poster.png',
                    'description' => 'Fresh out of college, a determined young coach takes on the challenge of transforming a struggling cross-country team at an all-girls Christian school. With their eyes set on their first state title, the coach teaches her runners not only how to compete but how to navigate the hurdles life throws their way. As each girl faces her own personal struggles—ranging from self-doubt, family pressures, and identity—the coach’s wisdom and guidance help them find their inner strength and purpose. Through hard work, faith, and unity, they come to realize that winning isn’t just about crossing the finish line but about growing as individuals. A heartwarming, inspirational story about overcoming adversity and embracing life’s challenges. 🌟👟🏅',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/FjcgE_neMmU?si=UZfRlev5Mi0bB7HW',
                    'movie_access' => 'free',
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [4,6,7],
                    'IMDb_rating' => null,
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:30',
                    'release_date' => '2024-05-28',
                    'is_restricted' => false,
                    'actors' =>[2,5,6,7,9,11,12,13,15,16,17,18],
                    'directors' => [24,25,26,27,28,29,30,31,32,34,36,37,38,40],
                    'countries' => [139,101],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/zH0EGqlb7eg?si=i8KsnlfbBWYAZZNk'
                ],
                [
                    'name' => 'Guardians of the Abyss: The Beast Awakens',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/guardians_of_the_abyss_the_beast_awakens_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/guardians_of_the_abyss_the_beast_awakens_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/guardians_of_the_abyss_the_beast_awakens_poster.png',
                    'description' => 'The Beast Awakens, a brave sailor embarks on a perilous journey across the high seas to stop a terrifying sea monster from destroying the ocean’s balance. Along the way, they form alliances with magical sea creatures and uncover secrets of the deep. This thrilling animated story is filled with heartwarming friendships, breathtaking battles, and awe-inspiring underwater worlds. 🐋⚓✨',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/c5QG-yZX2TI?si=HhK6G54dA40AShBt',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [2,8,4],
                    'content_rating' => 'PG (Parental Guidance Suggested)',
                    'duration' => '01:44',
                    'release_date' => '2024-06-01',
                    'is_restricted' => true,
                    'actors' => [1,2,5,6,7,10,11,12,13,14,15,16,17],
                    'directors' => [22,24,25,27,29,31,32,33,34,35,36,37],
                    'countries' => [160,170],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/hOj1RQMn37A?si=M0uQ8CMhvU6ohz-T'
                ],
                [
                    'name' => 'Journey to the Abyss',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/journey_to_the_abyss_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/journey_to_the_abyss_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/journey_to_the_abyss_poster.png',
                    'description' => '"Journey to the Abyss" follows a determined scientist, his brave nephew, and a fearless mountain guide as they venture into a mysterious and perilous lost world deep beneath the Earth\'s surface. Facing ancient creatures, treacherous landscapes, and deadly challenges, their quest for the truth becomes a thrilling race for survival. 🧭🌋🦖',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/GKq7QlNz3CA?si=E6fnSD4CvpEPcMu7',
                    'movie_access' => 'paid',
                    'plan_id' => 2,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [1,5,4], // Action genre
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:00',
                    'release_date' => '2024-05-04',
                    'is_restricted' => false,
                    'actors' => [2,3,4,8,9,10,13,14,16,18,19,20],
                    'directors' => [24,25,26,27,28,29,30,31,32,34,36,37,38,40],
                    'countries' => [145],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/M6h5AS971hY?si=T7Sf0Gjetp_7Ld2C'
            ],
                [
                    'name' => 'Lost in Ephesus',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/lost_in_ephesus_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/lost_in_ephesus_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/lost_in_ephesus_poster.png',
                    'description' => '❤️ "Lost in Ephesus" follows tourists Hope and Jeb as they find themselves stranded in Ephesus, Turkey, after their tour bus leaves without them. With Hope\'s belongings—including her purse, phone, and passport—on the bus, and Jeb facing a looming job crisis, they must navigate their way back to Istanbul with limited resources. As they traverse picturesque landscapes and tackle various obstacles, their journey turns into a heartfelt adventure. 🌟🚶‍♂️🚶‍♀️💖',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/CqTGjC4RExk?si=C_OT-SR1w98Au2Ut',
                    'movie_access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [7,5,4],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:45',
                    'release_date' => '2024-05-05',
                    'is_restricted' => false,
                    'actors' =>[1,3,4,5,6,7,9,10,11,12,15,16,17],
                    'directors' => [21,22,25,26,27,28,29,30,34,35,36,39,40],
                    'countries' => [117,101],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/PMeHdc25BGE?si=KPYxB7skuFDfsyHf'
                ],
                [
                    'name' => 'Broken Sanctuary',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/broken_sanctuary_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/broken_sanctuary_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/broken_sanctuary_poster.png',
                    'description' => 'David and Ana, two souls burdened by their histories who find hope in a quiet town. But when ruthless criminals invade their sanctuary, they must unite to protect their future. 🔥💀🔗🏚️',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/Mtah8SplQCA?si=4DqJPL6641jUR03m',
                    'movie_access' => 'paid',
                    'plan_id' => 2,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [8,6,5],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:30',
                    'release_date' => '2024-05-06',
                    'is_restricted' => false,
                    'actors' => [3,4,5,6,7,8,10,11,14,15,16,17,18],
                    'directors' => [22,23,25,28,29,30,31,33,34,36,37,39,40],
                    'countries' => [2,1],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/HvZKVGFVT5A?si=4blTPM-CLKKSLkw-'
                ],
                [
                    'name' => 'Wings of Kindness',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/wings_of_kindness_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/wings_of_kindness_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/wings_of_kindness_poster.png',
                    'description' => 'Young Lincoln, tormented by bullies, escapes his harsh reality by imagining a powerful superhero who embodies the strength he wishes he had. Meanwhile, a lonely man, adrift in life, finds hope and a new sense of purpose when he rescues a stray puppy. 🌟🐶👦',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/C7OQHIpDlvA?si=9srUjEIEX9bJ6eCB',
                    'movie_access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [6,3,4],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:06',
                    'release_date' => '2024-05-07',
                    'is_restricted' => false,
                    'actors' => [1,2,3,4,8,9,10,11,13,14,16,19,20],
                    'directors' => [24,25,26,27,28,29,30,31,32,34,36,37,38,40],
                    'countries' => [72,76],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/lHrFXTYPofc?si=G9JLJ8o64gAWdn9K'
                ],
                [
                    'name' => 'Mistaken for Love',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/mistaken_for_love_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/mistaken_for_love_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/mistaken_for_love_poster.png',
                    'description' => '💖 "Mistaken for Love" centers on Tenley, a horticulturist who bravely decides to meet her online crush, Jared, in person. However, a mix-up leads Jared’s family to believe that Tenley is his wife. 🌹🌿💑',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/PU0W26k_ZDI?si=QRf-PbREZT7MeIUt',
                    'movie_access' => 'paid',
                    'plan_id' => 2,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [7,4,5],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:15',
                    'release_date' => '2024-05-08',
                    'is_restricted' => true,
                    'actors' => [2,5,6,7,9,11,12,13,15,16,17,18],
                    'directors' => [21,22,25,26,27,28,29,30,34,35,36,39,40],
                    'countries' => [101],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/DfTzHiD_ngI?si=RsvfuvHVd-eIBt-k'
                ],
                [
                    'name' => 'Blade of Chaos',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/blade_of_chaos_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/blade_of_chaos_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/blade_of_chaos_poster.png',
                    'description' => 'The story of Charlie, a clumsy but well-meaning man who steps in to help at a local barbershop. Little does he know, the barbershop is a front for a secret spy organization, and now Charlie finds himself in the middle of an intense action-packed mission. With dangerous criminals on his tail and only a pair of scissors as his weapon, Charlie must navigate a world of chaos and high-stakes adventures. ✂️🕵️‍♂️💥🚗',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/-Qv6p6pTz5I?si=aeaLICb9s9VAgl4W',
                    'movie_access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [3,2,1],
                    'content_rating' => 'PG (Parental Guidance Suggested)',
                    'duration' => '03:56',
                    'release_date' => '2024-05-09',
                    'is_restricted' => false,
                    'actors' => [1,2,4,6,7,10,11,12,13,14,15,16,17],
                    'directors' =>[22,23,25,28,29,30,31,33,34,36,37,39,40],
                    'countries' => [49,38],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/OthBEy73VQ4?si=PdWE8bicX90lhHKb'
                ],
                [
                    'name' => 'Ayla: Path of the Lost Spirits',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/ayla_path_of_the_lost_spirits_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/ayla_path_of_the_lost_spirits_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/ayla_path_of_the_lost_spirits_poster.png',
                    'description' => 'In a vibrant world filled with ancient magic, Ayla, a young spirit guide, must navigate through dangerous lands and uncover hidden secrets. With the help of enchanted creatures, she sets out to reunite lost souls with the spirit world, battling dark forces that threaten to destroy the balance. A heartwarming and thrilling animated adventure where courage, friendship, and magic come together. 🌟🌀💫',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/V44I1TSFpOc?si=lbXNFs5EFCGc0Md4',
                    'movie_access' => 'paid',
                    'plan_id' => 2,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [2,3,4],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:50',
                    'release_date' => '2024-05-10',
                    'is_restricted' => true, // Set to true as per "Child Content"
                    'actors' => [2,3,5,8,9,10,13,14,16,18,19,20],
                    'directors' =>[21,22,25,26,27,28,29,30,34,35,36,39,40],
                    'countries' => [19,72],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/28CIeC8cZks?si=I5beoC48b6cqIadk'
                ],
                [
                    'name' => 'Warfront: Age of Reckoning',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/warfront_age_of_reckoning_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/warfront_age_of_reckoning_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/warfront_age_of_reckoning_poster.png',
                    'description' => 'The fragile peace between the Alliance and Horde shatters, plunging two mighty factions into a brutal war. As battles rage on land and sea, legendary heroes rise, forging alliances and clashing in epic confrontations that will decide the fate of entire kingdoms. Will peace ever return, or will chaos reign supreme? ⚔️🔥🌍',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/jSJr3dXZfcg?si=oUT5AA1E5p9d2GMy',
                    'movie_access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [1,4,6],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:55',
                    'release_date' => '2024-05-10',
                    'is_restricted' => false,
                    'actors' => [1,3,4,5,6,7,9,10,11,12,15,16,17],
                    'directors' =>[21,24,25,26,27,28,29,30,34,35,36,39,40],
                    'countries' => [37,49],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/gkBEd41mOIo?si=c-V7-nm68ZUGuQZM'
                ],
                [
                    'name' => 'Fang of the Steppe',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/fang_of_the_steppe_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/fang_of_the_steppe_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/fang_of_the_steppe_poster.png',
                    'description' => 'In this fantasy adventure, set in 800 BC, a brave warrior from the steppe embarks on an epic journey to unite 33 tribes against those who plunder and destroy their sacred lands. Mixing truth and fantasy, this tale reveals the origins of the fierce nomadic warriors who would shape history. 🏜️🐺⚔️',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/PI4Z7t3AZ5E?si=QNKYohZ1ZgLol_OP',
                    'movie_access' => 'pay-per-view',
                    'price' => 15,
                    'purchase_type' => 'rental',
                    'access_duration' => 5,
                    'discount' => 10,
                    'available_for' => 20,
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [5,6,7],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '01:50',
                    'release_date' => '2024-05-11',
                    'is_restricted' => false,
                    'actors' => [2,5,6,7,9,11,12,13,15,16,17,18],
                    'directors' => [22,23,24,28,29,30,31,32,34,36,37,38,40],
                    'countries' => [139,239],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/A5fBmZHgcT0?si=n8vuYfPWIsQCkMwg'
                ],
                [
                    'name' => 'Back to the Heartland',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/back_to_the_heartland_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/back_to_the_heartland_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/back_to_the_heartland_poster.png',
                    'description' => '🌾 "Back to the Heartland" follows Paisley, a spirited country girl determined to save her beloved grandfather’s ranch after being denied crucial funding. She reunites with her ex-boyfriend Josh, a marketing executive who has been temporarily suspended from his job. Despite their past, they join forces to brainstorm fundraising ideas for the ranch. Adding to the mix is Josh’s brother Sam, a close friend of Paisley’s, who returns to town just as Paisley and Josh begin to rekindle their relationship. As they face challenges and reminisce about old times, Paisley and Josh find that their love, which was always just beneath the surface, blooms once more. 🌹🚜💞',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/8jR2tLjciVg?si=ESb3SwaecBjcp7QX',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [7,8,3],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:40',
                    'release_date' => '2024-05-14',
                    'is_restricted' => false,
                    'actors' =>[1,2,3,4,8,9,10,11,13,14,16,19,20],
                    'directors' => [23,24,25,26,27,28,30,32,33,34,35,36,37,39],
                    'countries' => [231,238],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/BxHvI5BVBf4?si=HVJgCYw3t1FqmdiW'
                ],
                [
                    'name' => 'Isolated Tides',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/isolated_tides_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/isolated_tides_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/isolated_tides_poster.png',
                    'description' => '🌊 Two estranged sisters must put aside their differences to survive on a deserted island after a hot air balloon ride goes terribly wrong. These two sisters Emma and Sofia, estranged for years, are reunited by fate and disaster when their hot air balloon crash lands on a remote Mediterranean island. Stranded with no communication and limited resources, the sisters must navigate treacherous terrain, natural dangers, and their own bitter conflicts. As they battle for survival alongside trapped locals, they rediscover the power of family and their inner resilience. 🌅⛰️🏴‍☠️',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/hJo91wpGrz8?si=uVKgkkeEcNQjnp1r',
                    'movie_access' => 'paid',
                    'plan_id' => 2,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [4,5,6],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:35',
                    'release_date' => '2024-05-18',
                    'is_restricted' => false,
                    'actors' => [2,5,6,7,9,11,12,13,15,16,17,18],
                    'directors' => [24,25,26,27,28,29,30,31,32,34,36,37,38,40],
                    'countries' => [101,208],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/jwErAY9QjMA?si=bQ4MmYEq__pR6yjy'
                ],
                [
                    'name' => 'Sleepwalking Scares and Musical Mishaps',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/sleepwalking_scares_and_musical_mishaps_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/sleepwalking_scares_and_musical_mishaps_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/sleepwalking_scares_and_musical_mishaps_poster.png',
                    'description' => 'A musician\'s serene evening is upended when he discovers his roommate sleepwalking and causing a ruckus in their haunted house. The house’s eerie secrets and the musician’s attempts to deal with the bizarre happenings lead to a comedy of errors and spooky mishaps. This film combines musical humor with ghostly antics for a laugh-out-loud spooky adventure. 🎹🕵️‍♂️',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/j2Fec39AHJ8?si=c9WEIe5NXoF_tmrE',
                    'movie_access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [5,6],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:58',
                    'release_date' => '2024-05-21',
                    'is_restricted' => false,
                    'actors' => [1,2,4,6,7,10,11,12,13,14,15,16,17],
                    'directors' => [21,23,24,26,28,30,32,34,35,36,37,38,39,40],
                    'countries' => [209,206],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/rGsXo6cjKyE?si=sfVESt1ZmLTxMHrK'
                ],
                [
                    'name' => 'Grace Through the Storm',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/grace_through_the_storm_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/grace_through_the_storm_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/grace_through_the_storm_poster.png',
                    'description' => 'In the wake of a devastating tragedy, Dave Corwin is left shattered, struggling to comprehend the loss of his beloved wife. His grief drives a wedge between him and his son Steven, the only one left in their home who holds onto his Christian faith. As bitterness toward God festers in Dave, Steven is torn, desperate to bring healing to their relationship but unsure how to reach his father. With the guidance of prayer and the support of their community, Steven begins a journey to remind his father of God’s enduring love and purpose, even in the face of unimaginable grief. "Grace Through the Storm" is a touching story about faith, forgiveness, and the power of God’s sovereignty in times of struggle. 💫🙏🌿',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/edpVp4wZkbw?si=8mmVi8XE8m39aEur',
                    'movie_access' => 'paid',
                    'plan_id' => 3,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [4,5],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:40',
                    'release_date' => '2024-05-23',
                    'is_restricted' => false,
                    'actors' => [2,3,5,8,9,10,13,14,16,18,19,20],
                    'directors' => [22,24,25,27,29,31,32,33,34,35,36,37],
                    'countries' => [212,219],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/QL9vpp5MFiM?si=-DDQcUxVkapnSfoG'
                ],
                [
                    'name' => 'Elevator to the Heart',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/elevator_to_the_heart_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/elevator_to_the_heart_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/elevator_to_the_heart_poster.png',
                    'description' => '❤️ "Elevator to the Heart" follows Claire, a dedicated nurse who is struggling with a difficult supervisor. On a rare night off, she ends up stuck in an elevator with a charming and charismatic man, sparking a genuine connection between them. However, when she encounters him again the next day, he doesn\'t remember their previous encounter. As Claire navigates her challenging work life and tries to rekindle the magic of their chance meeting, she faces the ultimate test of fate and love. ❤️',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/bKuRQdEw5ZM?si=-6qzw0ljqmEiCLUR',
                    'movie_access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [7,8],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:50',
                    'release_date' => '2024-05-26',
                    'is_restricted' => false,
                    'actors' =>[1,3,4,5,6,7,9,10,11,12,15,16,17],
                    'directors' =>[22,23,25,28,29,30,31,33,34,36,37,39,40],
                    'countries' => [229,224],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/72gTHNo9b5E?si=HkVSUTVT-QWHNUtd'
                ],
                [
                    'name' => 'Taru\'s Quest',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/taru_quest_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/taru_quest_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/taru_quest_poster.png',
                    'description' => 'Taru, a young zebra born without his back stripes, embarks on a courageous journey to the Sacred River, where it\'s believed his stripes will be completed. Along the way, he faces challenges and learns the true meaning of belonging. 🦓✨',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/j-cbM0NVs9o?si=xufUqhULsS_kmKNf',
                    'movie_access' => 'paid',
                    'plan_id' => 3,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [2,6,7],
                    'content_rating' => 'PG (Parental Guidance Suggested)',
                    'duration' => '02:56',
                    'release_date' => '2024-05-27',
                    'is_restricted' => true,
                    'actors' =>  [2,4,7,8,9,12,13,14,15,16,19,20],
                    'directors' => [24,25,26,27,28,29,30,31,32,34,36,37,38,40],
                    'countries' => [101,29],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/Jv9qeD0tLeE?si=Z26gJHLZHnaESg-J'
                ],
                [
                    'name' => 'Twisted Trails',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/twisted_trails_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/twisted_trails_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/twisted_trails_poster.png',
                    'description' => 'A novice camper, as his peaceful escape into nature spirals into chaos. When he stumbles upon a woman trapped in a car, his survival instincts kick in—but as he becomes the target of a ruthless killer, he realizes the true mystery is far more complex. With every turn revealing new twists, the truth of the events remains elusive until the shocking final moments. This fast-paced thriller will leave you questioning every character’s motives. 🌲🛶❓',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/FXOtkvx25gI?si=iD3LrO0BIQv7Fz4d',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [8,7,5],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:45',
                    'release_date' => '2024-05-28',
                    'is_restricted' => false,
                    'actors' => [3,5,6,7,8,9,10,11,12,16,17,18],
                    'directors' => [21,23,24,26,28,30,32,34,35,36,37,38,39,40],
                    'countries' => [36,45],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/nujakIrBDCU?si=cXGG42k3lquWC2It'
                ],
                [
                    'name' => 'Mystic Isle',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/mystic_isle_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/mystic_isle_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/mystic_isle_poster.png',
                    'description' => 'On a remote, mystical island, General Wang Sheng rescues the enchanting Xiao Wei, unaware of her hidden powers. As romance blossoms, strange and terrifying events begin to unfold, and a brave demon hunter uncovers the truth—Xiao Wei is no ordinary woman but a powerful spirit with a dangerous past. 🌿💫🌀',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/H0u8yO9kiAA?si=V__ZIHm_Pu3yCqI8',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [4,3,6],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:35',
                    'release_date' => '2024-05-30',
                    'is_restricted' => false,
                    'actors' => [1,2,4,8,11,12,13,14,15,19,20],
                    'directors' => [22,24,25,27,29,31,32,33,34,35,36,37],
                    'countries' => [220],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/5ZB6dhrgtxc?si=plIOjL9dVPa3hDm7'
                ],
                [
                    'name' => 'Guided Through Grief',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/guided_through_grief_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/guided_through_grief_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/guided_through_grief_poster.png',
                    'description' => '🌟 "Guided Through Grief" stars Clifton Powell and delves into the lives of two individuals from distinct backgrounds who are profoundly affected by sudden family deaths. As they grapple with their grief and seek meaning in their pain, they form a bond that helps them navigate the complexities of their sorrow. Their journey is a powerful testament to how shared experiences can bring solace and understanding in the darkest times. 🌟💔',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/dbmvLoZKx_o?si=ZwVTkx1D4AJZ7QZG',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [6,1,2],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '01:25',
                    'release_date' => '2024-05-31',
                    'is_restricted' => false,
                    'actors' =>  [3,4,5,6,7,10,11,14,15,16,17,18],
                    'directors' => [24,25,26,27,28,29,30,31,32,34,36,37,38,40],
                    'countries' => [7,180],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/F8IPzpcuPGs?si=QVeVrBUAdescWzfs'
                ],
                [
                    'name' => 'Rogue Redemption',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/rogue_redemption_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/rogue_redemption_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/rogue_redemption_poster.png',
                    'description' => '🌊 Cai Yan, a fearless pirate leader, is struck by amnesia and finds refuge in the Southern Shaolin Temple. As he recovers, he discovers the monks\' ongoing struggle against a powerful threat. With new purpose, Cai Yan decides to defend the temple, mastering both combat and his forgotten past. 🌊⚔️🛕',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/5RF3ER2knsc?si=oS_l1s_w1WkRMVUj',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [1,4,5],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:50',
                    'release_date' => '2024-06-01',
                    'is_restricted' => false,
                    'actors' => [1,2,3,8,9,10,13,14,15,18,20],
                    'directors' => [21,22,25,26,27,28,29,30,34,35,36,39,40],
                    'countries' => [19,80],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/kfVIRmx3saM?si=hcZcQ_-hIZwJQBnw'
                ],
                [
                    'name' => 'Spectral Surprises',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/spectral_surprises_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/spectral_surprises_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/spectral_surprises_poster.png',
                    'description' => '👻 In "Spectral Surprises," Sanaya\'s life of continuous misfortune takes a dark turn when she becomes the vessel for a restless and vengeful spirit. While the ghost seems to improve her luck with a series of eerie yet positive changes, Sanaya soon suspects that the spirit harbors a more sinister secret. As she uncovers the ghost\'s true motives, she must confront the chilling reality of its dark purpose. 👻🕯️',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/Jxq13WJxLDY?si=AjKX1zULDPQ-Lqiw',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [5,2,3],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '01:30',
                    'release_date' => '2024-06-03',
                    'is_restricted' => false,
                    'actors' => [4,5,6,7,11,12,13,16,17,19,20],
                    'directors' => [21,22,25,26,27,28,29,30,34,35,36,39,40],
                    'countries' => [70,99],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/gmO2_FcfhgY?si=5eBx8QyzklYCih-R'
                ],
                [
                    'name' => 'Gramps and the Grandkid Circus',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/gramps_and_the_grandkid_circus_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/gramps_and_the_grandkid_circus_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/gramps_and_the_grandkid_circus_poster.png',
                    'description' => '👴 When wealthy and self-centered David McDoll inherits his six rambunctious grandchildren, his once orderly life devolves into uproarious chaos. As he struggles to adapt to his new role as a grandfather, his lavish lifestyle is turned upside down by the kids\' wild antics. Through hilarious misadventures and family bonding, David learns the true meaning of love and appreciation. 👴👧😂🚗',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/mJ_Tex6KT6w?si=0bhjIh5zYTZlk9EU',
                    'movie_access' => 'pay-per-view',
                    'price' => 22,
                    'purchase_type' => 'rental',
                    'access_duration' => 2,
                    'discount' => 10,
                    'available_for' => 20,
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [3,4,7],
                    'content_rating' => 'PG (Parental Guidance Suggested)',
                    'duration' => '02:30',
                    'release_date' => '2024-06-05',
                    'is_restricted' => false,
                    'actors' => [1,3,4,5,6,8,10,11,12,13,14,17,18],
                    'directors' => [22,23,25,28,29,30,31,33,34,36,37,39,40],
                    'countries' => [30,40],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/tGgKsV0lgsU?si=V5AN1wYc8Q72KSEB'
                ],
                [
                    'name' => 'Texting for Love',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/texting_for_love_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/texting_for_love_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/texting_for_love_poster.png',
                    'description' => '💌 "Texting for Love" is a charming romantic comedy where Mira Ray, struggling with the loss of her fiancé, starts sending romantic texts to his old cell phone number, now belonging to Rob Burns. Rob, a journalist enchanted by the sincere messages, teams up with megastar Celine Dion to help find Mira. As Rob navigates the path to Mira\'s heart with Celine\'s guidance, the story unfolds into a heartwarming journey of love and destiny. 🌟📱💖',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/CQDXtD2HJAs?si=p9loI6UOGTOniMbO',
                    'movie_access' => 'pay-per-view',
                    'price' => 16,
                    'purchase_type' => 'rental',
                    'access_duration' => 3,
                    'discount' => 10,
                    'available_for' => 20,
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [7,6,5],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:00',
                    'release_date' => '2024-06-06',
                    'is_restricted' => false,
                    'actors' => [2,4,7,8,9,12,13,14,15,16,19,20],
                    'directors' => [24,25,26,27,28,29,30,31,32,34,36,37,38,40],
                    'countries' => [70,80],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/9QL07ep7HA0?si=dYpRYVGRwmuXa9r2'
                ],
                [
                    'name' => 'Vengeance in the Wild',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/vengeance_in_the_wild_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/vengeance_in_the_wild_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/vengeance_in_the_wild_poster.png',
                    'description' => '🌾 A young refugee girl must navigate the deadly Australian wilderness while being hunted by a man seeking revenge for his son’s death. ⛰️🏴‍☠️',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/EbrTRE96wS0?si=GVHICrYbbCTkGA35',
                    'movie_access' => 'pay-per-view',
                    'price' => 22,
                    'purchase_type' => 'rental',
                    'access_duration' => 4,
                    'discount' => 10,
                    'available_for' => 20,
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [8,1,2],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:45',
                    'release_date' => '2024-06-10',
                    'is_restricted' => false,
                    'actors' => [3,5,6,7,8,9,10,11,12,16,17,18],
                    'directors' => [21,22,25,26,27,28,29,30,34,35,36,39,40],
                    'countries' => [79,37],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/jUg6dBuRR88?si=8HWEw7cT5rHWugg4'
                ],
                [
                    'name' => 'Phantom\'s Deception',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/phantoms_deception_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/phantoms_deception_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/phantoms_deception_poster.png',
                    'description' => '👻 In "Phantom\'s Deception," Sanaya’s life takes an unsettling turn when she becomes the host for a malevolent spirit. While the ghost appears to bring unexpected good fortune into her life, its true purpose slowly emerges as a web of deception and terror. As Sanaya navigates through her newfound luck, she must uncover the ghost’s hidden motives before it’s too late. This horror film intertwines supernatural elements with psychological suspense, creating a gripping tale of hidden dangers and eerie surprises. 👻🕵️‍♀️🔮',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/melKmunBhBs?si=A7WVsdnCLWShLBJk',
                    'movie_access' => 'paid',
                    'plan_id' => 2,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [5,3,4],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:30',
                    'release_date' => '2024-06-12',
                    'is_restricted' => false,
                    'actors' =>[1,2,4,8,11,12,13,14,15,19,20],
                    'directors' => [22,23,25,28,29,30,31,33,34,36,37,39,40],
                    'countries' => [78,49,58],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/k7tLllmRVu4?si=ApNtZFl8hs-Bfptf'
                ],
                [
                    'name' => 'Sniper\'s Redemption',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/snipers_redemption_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/snipers_redemption_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/snipers_redemption_poster.png',
                    'description' => 'Ace Sniper Brandon Beckett joins forces with the Global Response & Intelligence Team (G.R.I.T.) to rescue a kidnapped agent and thwart a deadly international terrorist cult. Racing against time, the team infiltrates Malta and engages in high-stakes battles to stop the cult leader and save the world from chaos. 🧨🎯🌍',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/AAT4TCet1KQ?si=-zAAC3C_mGI4Bzco',
                    'movie_access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [1,2,6],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:06',
                    'release_date' => '2024-06-14',
                    'is_restricted' => false,
                    'actors' => [2,4,7,8,9,12,13,14,15,16,19,20],
                    'directors' =>[21,22,25,26,27,28,29,30,34,35,36,39,40],
                    'countries' => [7,17,27,37],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/9E1SkxFhSP4?si=_Dd3oLFGHpu9t4gS'
                ],
                [
                    'name' => 'Camera Capers: The Great Identity Mix-Up',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/camera_capers_the_great_identity_mix_up_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/camera_capers_the_great_identity_mix_up_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/camera_capers_the_great_identity_mix_up_poster.png',
                    'description' => 'A bumbling amateur photographer\'s brand-new camera is swiped, setting off a riotous chase filled with humorous mix-ups and unlikely suspects. As he stumbles from one comedic situation to the next, he learns that sometimes the best detective is the one who can\'t stop tripping over their own feet. 📷😂🕵️‍♂️',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/7mT8El4mBVw?si=QURW5DdZ0HMm1wOm',
                    'movie_access' => 'paid',
                    'plan_id' => 2,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [3,5],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:15',
                    'release_date' => '2024-06-15',
                    'is_restricted' => true,
                    'actors' => [1,2,3,4,8,9,10,11,13,14,16,19,20],
                    'directors' => [21,24,25,26,27,28,29,30,34,35,36,39,40],
                    'countries' => [7,17,27],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/MCkqzUQOdUo?si=kGz6iHjGq5qa2L0t'
                ],
                [
                    'name' => 'Harbor of Hearts',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/harbor_of_hearts_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/harbor_of_hearts_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/harbor_of_hearts_poster.png',
                    'description' => '🌊 "Harbor of Hearts" tells the story of Lily, an interior designer who returns to her family’s marina-side bed and breakfast to assist her aunt Maggie. While there, she meets Marcus, a handsome seaplane pilot who delivers rescue dogs. As they work closely together, Lily learns that the real meaning of home and love goes beyond physical places, finding her heart anchored in unexpected connections and newfound romance. 🏡❤️🛩️',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/zF9YIYc0d7w?si=XRdhC2qJ7y5yfAmL',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [7,6],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:56',
                    'release_date' => '2024-06-18',
                    'is_restricted' => false,
                    'actors' => [2,5,6,7,9,11,12,13,15,16,17,18],
                    'directors' => [22,23,24,28,29,30,31,32,34,36,37,38,40],
                    'countries' => [70,17,246],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/p8egZga9Fqs?si=Lbo-6CacHJMkLEYB'
                ],
                [
                    'name' => 'Fatal Obsession',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/fatal_obsession_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/fatal_obsession_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/fatal_obsession_poster.png',
                    'description' => 'Tobias believes he\'s finally found "the one," but his romance soon transforms into a nightmare as strange accidents and eerie coincidences plague his life. Each incident seems connected to his new love, whose mysterious past holds terrifying secrets. What starts as passion turns into a gripping game of survival, as Tobias uncovers the truth behind the deadly events surrounding him. This thriller will keep you guessing until the shocking conclusion. 😱🔪😨💔',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/nRPFGrwDlwU?si=Ag-sZc1wjieY2sDu',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [8,1],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:50',
                    'release_date' => '2024-06-20',
                    'is_restricted' => false,
                    'actors' => [1,2,4,6,7,10,11,12,13,14,15,16,17],
                    'directors' => [23,24,25,26,27,28,30,32,33,34,35,36,37,39],
                    'countries' => [101],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/-KP8vE35DkU?si=MwTMLbfZtgzfp-Sj'
                ],
                [
                    'name' => 'Forsaken Battalion',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/forsaken_battalion_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/forsaken_battalion_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/forsaken_battalion_poster.png',
                    'description' => 'A group of German soldiers finds themselves abandoned by their retreating comrades in the heat of battle. Cut off from their main forces and surrounded by enemies, they must band together and fight against overwhelming odds in a desperate attempt to survive and reclaim their honor. 💥⚔️🏞️',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/aDyQxtg0V2w?si=ydtmf91vHvNuvVMX',
                    'movie_access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [1,6,7],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:55',
                    'release_date' => '2024-06-20',
                    'is_restricted' => false,
                    'actors' => [2,3,5,8,9,10,13,14,16,18,19,20],
                    'directors' => [24,25,26,27,28,29,30,31,32,34,36,37,38,40],
                    'countries' => [240],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/PdxPlbKFkaM?si=H_nwgJKc4Ioqj1tR'
                ],
                [
                    'name' => 'The Charlie Game: Shadows Unleashed',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/the_charlie_game_shadows_unleashed_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/the_charlie_game_shadows_unleashed_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/the_charlie_game_shadows_unleashed_poster.png',
                    'description' => 'The Charlie Game: Shadows Unleashed follows Lily, whose attempt to play the eerie Charlie Charlie game leads to a nightmarish encounter with the supernatural. As the pencils eerily respond to her questions, the room transforms into a haunted labyrinth of flickering candlelight and menacing shadows. With each movement, the tension escalates, and Lily’s once innocent curiosity turns into a battle against unseen horrors. This chilling short film promises a heart-pounding experience with unexpected twists and ghostly frights. 👻🔮🕯️🎲',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/mIaKS3OtqEg?si=-qrD6nVQxrTGsSm-',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [5,3,2],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '01:50',
                    'release_date' => '2024-06-21',
                    'is_restricted' => false,
                    'actors' => [1,3,4,5,6,7,9,10,11,12,15,16,17],
                    'directors' => [21,23,24,26,28,30,32,34,35,36,37,38,39,40],
                    'countries' => [49,28],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/G8ngi-HhojM?si=A5PlBdA0msPJKt3o'
                ],
                [
                    'name' => 'Warriors of the Eternal Realm',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/warriors_of_the_eternal_realm_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/warriors_of_the_eternal_realm_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/warriors_of_the_eternal_realm_poster.png',
                    'description' => 'In an ancient world filled with legendary heroes and mythical creatures, a group of young warriors must unite to protect their realm from an impending invasion. Armed with powerful abilities and guided by ancient prophecies, they embark on a thrilling journey to save their homeland from dark forces threatening to engulf it. ⚔️🌍✨',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/7VXOHmaTd7g?si=Qjm-q92VPXnVG5NN',
                    'movie_access' => 'pay-per-view',
                    'price' => 30,
                    'purchase_type' => 'rental',
                    'access_duration' => 1,
                    'discount' => 10,
                    'available_for' => 20,
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [4,1,6],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:40',
                    'release_date' => '2024-06-22',
                    'is_restricted' => false,
                    'actors' => [2,4,7,8,9,12,13,14,15,16,19,20],
                    'directors' => [22,24,25,27,29,31,32,33,34,35,36,37],
                    'countries' => [74,82],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/RhBJ5qrGvGI?si=I5F5ozAIp1jRbJDH',
                ],

                [
                    'name' => 'London Love Revisited',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/london_love_revisited_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/london_love_revisited_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/london_love_revisited_poster.png',
                    'description' => '“London Love Revisited” follows Edie, who finds the love of her life in London just before her return to the US. Although they are separated by miles and time, fate intervenes and reunites them six years later in America. Their love story unfolds as they navigate the twists and turns of life and love, proving that true connections withstand the test of time and distance. 💕🗺️✨',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/cT_FWfIz4Q8?si=g-i6T9exs8tycqbw',
                    'movie_access' => 'paid',
                    'plan_id' => 2,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [7,8,4],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:35',
                    'release_date' => '2024-06-28',
                    'is_restricted' => false,
                    'actors' =>  [3,5,6,7,8,9,10,11,12,16,17,18],
                    'directors' => [21,23,24,26,28,30,32,34,35,36,37,38,39,40],
                    'countries' => [38,101,49],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/Wx0wO9WD9Zg?si=wbvgSHuoDu4Rk25V',
                ],

                [
                    'name' => 'Wild Spring Break with Grandpa',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/wild_spring_break_with_grandpa_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/wild_spring_break_with_grandpa_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/wild_spring_break_with_grandpa_poster.png',
                    'description' => 'The hilarious misadventures of Jason Kelly, a buttoned-up lawyer-to-be, who gets roped into a wild road trip with his outrageous grandfather. As they hit the road for Daytona Beach, chaos ensues with outrageous parties, karaoke showdowns, and unexpected life lessons. Through all the madness, both Jason and his "dirty" grandpa learn about family, fun, and embracing life\'s wild side. 🚗🍻🎤',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/skl7gYRZHwE?si=kiekCHcihmEJH54D',
                    'movie_access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [3,6,7],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:58',
                    'release_date' => '2024-06-29',
                    'is_restricted' => false,
                    'actors' => [1,2,4,8,11,12,13,14,15,19,20],
                    'directors' => [22,24,25,27,29,31,32,33,34,35,36,37],
                    'countries' => [46,28],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/3S2aWcZ4wOo?si=T2mMZZDcruqbiNce',
                ],

                [
                    'name' => 'Into the Wilderness',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/into_the_wilderness_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/into_the_wilderness_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/into_the_wilderness_poster.png',
                    'description' => 'In "Into the Wilderness," four childhood friends reunite at a secluded cabin to rekindle their bond after years apart. What begins as a peaceful retreat quickly turns into a suspenseful nightmare when they realize something sinister lurks in the surrounding woods. As the tension builds, their friendship is tested, and survival becomes the only priority. This family-friendly thriller is packed with mystery, unexpected twists, and heart-pounding moments that will keep you on the edge of your seat. 🏞️🕯️🌲',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/pAxGJfEYuJI?si=phHEzZJDHV0q3pjb',
                    'movie_access' => 'paid',
                    'plan_id' => 2,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [8,1,2],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:40',
                    'release_date' => '2024-06-30',
                    'is_restricted' => false,
                    'actors' => [3,4,5,6,7,10,11,14,15,16,17,18],
                    'directors' => [24,25,26,27,28,29,30,31,32,34,36,37,38,40],
                    'countries' => [10,20],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/eoqWQLYGmPM?si=2pqtg8-Jp6dxP3mD',
                ],

                [
                    'name' => 'Colors of Hope',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/colors_of_hope_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/colors_of_hope_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/colors_of_hope_poster.png',
                    'description' => '“Colors of Hope” tells the story of Winter Knight, a young girl with a vibrant artistic talent, who is weighed down by the challenges of dyslexia. As she struggles to navigate school, friendships, and daily life, she begins to feel defined by her limitations rather than her abilities. Overwhelmed by feelings of hopelessness, Winter loses sight of her unique gifts. However, her journey takes a transformative turn as she discovers that her struggles have shaped her into someone extraordinary. With perseverance, faith, and support, Winter learns that her pain has a greater purpose, and through her art, she can inspire others. 🎨🌈💪',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/BSWw80zzB48?si=zXTNQ2i0W30uBb2k',
                    'movie_access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [6,4,5],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:50',
                    'release_date' => '2024-07-01',
                    'is_restricted' => false,
                    'actors' =>  [1,2,3,4,8,9,10,11,13,14,16,19,20],
                    'directors' => [21,22,25,26,27,28,29,30,34,35,36,39,40],
                    'countries' => [49,2],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/sCwxAxeTymc?si=I2LZLF1h6CvIRvNK',
                ],
                [
                    'name' => 'Wolves of the Dawn',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/wolves_of_the_dawn_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/wolves_of_the_dawn_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/wolves_of_the_dawn_poster.png',
                    'description' => 'Many tribes unite to defend their homeland against invaders who desecrate their sacred grounds. Through fierce battles and legendary alliances, they fight to preserve their future, giving rise to a powerful legacy that will echo throughout history. ⚔️🐺🌄',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/MAFsRmx6pPo?si=CJjoeRbHVtKJt9oC',
                    'movie_access' => 'pay-per-view',
                    'price' => 40,
                    'purchase_type' => 'onetime',
                    'discount' => 10,
                    'available_for' => 20,
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [4,1,5],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:56',
                    'release_date' => '2024-07-04',
                    'is_restricted' => false,
                    'actors' => [2,5,6,7,9,11,12,13,15,16,17,18],
                    'directors' => [22,23,25,28,29,30,31,33,34,36,37,39,40],
                    'countries' => [17],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/VOwUgraDBFI?si=1IUq1nOWZzSogcE8',
                ],
                [
                    'name' => 'Legends of the Eternal Flame',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/legends_of_the_eternal_flame_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/legends_of_the_eternal_flame_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/legends_of_the_eternal_flame_poster.png',
                    'description' => 'A historical animated adventure set in an ancient kingdom, where mythical creatures, brave warriors, and powerful magic collide. The story follows a young warrior on a quest to protect a legendary flame that holds the balance of the kingdom\'s fate. Along the journey, he learns about courage, friendship, and the responsibilities of wielding great power. 🌋⚔️',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/nzzq4V2I6hE?si=wkokzDNAvvxLY9Tm',
                    'movie_access' => 'pay-per-view',
                    'price' => 40,
                    'purchase_type' => 'onetime',
                    'discount' => 10,
                    'available_for' => 20,
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [2,4,5],
                    'content_rating' => 'PG (Parental Guidance Suggested)',
                    'duration' => '02:45',
                    'release_date' => '2024-07-06',
                    'is_restricted' => true,
                    'actors' =>[1,2,4,6,7,10,11,12,13,14,15,16,17],
                    'directors' => [23,24,25,26,28,29,30,32,33,34,35,36,37,39],
                    'countries' => [7,25],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/QAYFz3owVRk?si=pSWSgkzyodKbfomo',
                ],
                [
                    'name' => 'The House of Last Respite',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/the_house_of_last_respite_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/the_house_of_last_respite_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/the_house_of_last_respite_poster.png',
                    'description' => '🏚️ "The House of Last Respite" follows two families who stumble upon a seemingly perfect farmhouse, only to find themselves trapped in a horrifying nightmare. When they rescue a mute girl with a brutal past, they discover that every escape attempt leads them back to the same sinister house. As they face the wrath of a malevolent former owner, their unity unravels into chaos and terror. The house demands a horrifying choice: only one family will survive and claim it as their home. 😱🔪🏠',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/WaewToFT59c?si=204R6vnVc3NfrrN5',
                    'movie_access' => 'pay-per-view',
                    'price' => 40,
                    'purchase_type' => 'onetime',
                    'discount' => 10,
                    'available_for' => 20,
                    'plan_id' => null,
                    'status' => 2,
                    'language' => 'english',
                    'genre_id' => [5,3],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:35',
                    'release_date' => '2024-07-08',
                    'is_restricted' => false,
                    'actors' => [2,3,5,8,9,10,13,14,16,18,19,20],
                    'directors' =>[21,24,25,26,27,28,29,30,34,35,36,39,40],
                    'countries' => [27,37],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/XimvdthKNas?si=ICjfDs44I0_nmK-k',
                ],
                [
                    'name' => 'The Monarch\'s Last Hope',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/the_monarchs_last_hope_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/the_monarchs_last_hope_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/the_monarchs_last_hope_poster.png',
                    'description' => 'When the king is kidnapped, a team of skilled beauty agents is called upon to rescue him. Their mission takes them across treacherous landscapes and through deadly battles as they fight to bring the king back before it\'s too late. ⚔️👑🚁',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/Z5W1aLsgAMI?si=BgYhG4m-47JoIzvZ',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [1,5,6],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '01:25',
                    'release_date' => '2024-07-09',
                    'is_restricted' => false,
                    'actors' =>  [1,3,4,5,6,7,9,10,11,12,15,16,17],
                    'directors' => [22,23,24,28,29,30,31,32,34,36,37,38,40],
                    'countries' => [210,187],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/zWY_vGKN2kE?si=7LQnMTbm_zoEjTDJ',
                ],
                [
                    'name' => 'Aunt Nell\'s Babysitting Blues',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/aunt_nells_babysitting_blues_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/aunt_nells_babysitting_blues_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/aunt_nells_babysitting_blues_poster.png',
                    'description' => 'Nell\'s hilarious attempts to bond with her indifferent niece, Tilly. When Nell feels overshadowed by Tilly\'s fascination with a new friend, Edward, her babysitting gig turns into a series of comedic mishaps. 🍕🎈',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/AqW9MGeauOs?si=4kwGJ3ecgU96WKaH',
                    'movie_access' => 'paid',
                    'plan_id' => 2,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [3,6,8],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '01:30',
                    'release_date' => '2024-07-11',
                    'is_restricted' => false,
                    'actors' => [2,4,7,8,9,12,13,14,15,16,19,20],
                    'directors' => [23,24,25,26,27,28,30,32,33,34,35,36,37,39],
                    'countries' => [120,180],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/7ij1BulfHWU?si=v30_ZzB99dmfUTiG',
                ],
                [
                    'name' => 'The Iron Cavalry',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/the_iron_cavalry_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/the_iron_cavalry_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/the_iron_cavalry_poster.png',
                    'description' => 'Captain Balram Singh Mehta and his 45 Cavalry regiment face fierce battles on the eastern front during the 1971 Indo-Pakistani War. Named after the Russian PT-76 tank, the film captures Mehta\'s journey from a determined soldier to a hero fighting for Bangladesh’s freedom. The story highlights courage and sacrifice amidst a pivotal historical conflict. 🎖️🔥',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/i2vFwRTOKa4?si=zsyLY5PNUnb7SAlL',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'hindi',
                    'genre_id' => [4,7],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:30',
                    'release_date' => '2024-07-12',
                    'is_restricted' => false,
                    'actors' =>[3,5,6,7,8,9,10,11,12,16,17,18],
                    'directors' =>  [24,25,26,27,28,29,30,31,32,34,36,37,38,40],
                    'countries' => [230,17],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/vAp-9i4mFBQ?si=53kE_c6K8fftINMb'
                ],
                [
                    'name' => 'The Cavern of Titans',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/the_cavern_of_titans_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/the_cavern_of_titans_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/the_cavern_of_titans_poster.png',
                    'description' => 'The tale of a daring expedition into a subterranean realm, where colossal creatures and forgotten civilizations thrive. As the explorers face unimaginable dangers, they must rely on their courage and wits to uncover the secrets of the deep and return to the world above. 🏔️🐉🌪️',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/iJkspWwwZLM?si=chtl8vdmLqPNKPfE',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [6,5,8],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '01:25',
                    'release_date' => '2024-07-15',
                    'is_restricted' => false,
                    'actors' => [1,2,4,8,11,12,13,14,15,19,20],
                    'directors' => [21,23,24,26,28,30,32,34,35,36,37,38,39,40],
                    'countries' => [2,9],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/16TqpaRYTd8?si=l2tsBSCpD3fLwIFU'
                ],
                [
                    'name' => 'Family Feud Fiasco',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/family_feud_fiasco_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/family_feud_fiasco_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/family_feud_fiasco_poster.png',
                    'description' => 'When the Jones family\'s estranged patriarch dies unexpectedly on their doorstep. As a well-meaning paramedic tries to ease tensions and win over the grumpy Jean Jones, old family disputes flare up during the funeral, leading to a series of comical and awkward situations. Amidst the chaos, the family must confront their past and find a way to come together, all while navigating hilarious mishaps and misunderstandings. 🏠🚑🎉',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/0Ji6i79LiL8?si=IIG3-D6Jl72oJq0_',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [1,3],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '01:30',
                    'release_date' => '2024-07-18',
                    'is_restricted' => false,
                    'actors' => [3,4,5,6,7,10,11,14,15,16,17,18],
                    'directors' => [23,24,25,26,27,28,30,32,33,34,35,36,37,39],
                    'countries' => [27,37],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/JAoR9u85DQ0?si=JggaatJIEG5HxlOm'
                ],
                [
                    'name' => 'Voice of Freedom: The Hero\'s Journey',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/voice_of_freedom_the_heros_journey_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/voice_of_freedom_the_heros_journey_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/voice_of_freedom_the_heros_journey_poster.png',
                    'description' => 'Set in ancient times, this historical animated film tells the inspiring story of a young boy, enslaved and torn from his homeland, who dreams of becoming a great warrior. Facing oppression and hardship, he discovers his inner strength and courage to fight for his freedom and that of his people. Through his unwavering faith and determination, he becomes a symbol of hope and liberation for his entire community. 🗡️🕊️',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/VhrZBHwOMUs?si=1tIuoknprcIy9m5T',
                    'movie_access' => 'paid',
                    'plan_id' => 3,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [2,4],
                    'content_rating' => 'PG (Parental Guidance Suggested)',
                    'duration' => '02:30',
                    'release_date' => '2024-07-20',
                    'is_restricted' => false,
                    'actors' => [1,3,4,5,6,7,9,10,11,12,15,16,17],
                    'directors' => [24,25,26,27,28,29,30,31,32,34,36,37,38,40],
                    'countries' => [220,77],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/VGqRrFzrM3g?si=rpfa_Ozf-4TYQj7K'
                ],
                [
                    'name' => 'The Silent Sentinel',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/the_silent_sentinel_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/the_silent_sentinel_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/the_silent_sentinel_poster.png',
                    'description' => 'In a gripping portrayal of the Indo-Pak War, "The Silent Sentinel" follows two Indian Army soldiers—a sniper and his spotter—trapped in a moral conflict as they face off against their adversaries. This historical thriller explores the depths of war\'s impact with suspenseful drama and an evocative soundtrack. 🎖️🕊️',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/QROfT5dT_yQ?si=6BjCzjHBnjfg6CWG',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [4,8],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '03:00',
                    'release_date' => '2024-07-24',
                    'is_restricted' => false,
                    'actors' =>[2,4,7,8,9,12,13,14,15,16,19,20],
                    'directors' => [21,23,24,26,28,30,32,34,35,36,37,38,39,40],
                    'countries' => [27,37],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/JEKCMP3w9zs?si=ylfFHdeYPonn4_8t'
                ],
                [
                    'name' => 'Unspoken Bonds',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/unspoken_bonds_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/unspoken_bonds_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/unspoken_bonds_poster.png',
                    'description' => '"Unspoken Bonds" follows Hannah and her daughter Esme, whose days are numbered due to a devastating illness. Hoping for a final chance to connect, they retreat to an isolated family farm. As they struggle to find peace, unspoken truths emerge, creating tension and suspense that grips both mother and daughter. This emotional thriller reveals that sometimes the darkest secrets are the ones buried deep within, and they must confront their pain to truly find each other before it\'s too late. 🌾💔',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/O9i2vmFhSSY?si=c-irbe19bosTBub6',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [1,8],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:45',
                    'release_date' => '2024-07-27',
                    'is_restricted' => false,
                    'actors' => [3,5,6,7,8,9,10,11,12,16,17,18],
                    'directors' => [22,24,25,27,29,31,32,33,34,35,36,37],
                    'countries' => [2,37],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/bmiRXkvdPz0?si=TN-kOSlWL-TNknPj'
                ],
                [
                    'name' => 'Against All Odds',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/against_all_odds_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/against_all_odds_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/against_all_odds_poster.png',
                    'description' => '🏅🔥 "Against All Odds" tells the inspiring true story of Gail Devers, a world-class sprinter whose career was nearly derailed by a life-threatening illness. Faced with the possibility of never running again, Gail’s future looked uncertain. But her incredible willpower, perseverance, and unwavering belief in herself led her to a stunning victory at the 1992 Barcelona Olympics, where she claimed the Gold Medal in the 100-meter sprint. "Against All Odds" is a testament to the human spirit’s ability to rise above adversity and achieve greatness, no matter the obstacles. 🏆💪🌟',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/pRH5u5lpArQ?si=JZPYWGGJDohHxmQf',
                    'movie_access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [4,7,6],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:30',
                    'release_date' => '2024-07-30',
                    'is_restricted' => false,
                    'actors' => [1,2,4,8,11,12,13,14,15,19,20],
                    'directors' => [23,24,25,26,27,28,30,32,33,34,35,36,37,39],
                    'countries' => [27,37],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/F2nO-6mzCF8?si=QxOosE72QHcl5nrT'
                ],
                [
                    'name' => 'Hearts of Valor',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/hearts_of_valor_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/hearts_of_valor_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/hearts_of_valor_poster.png',
                    'description' => 'Set in a dynamic animated world, "Hearts of Valor" reimagines Shakespeare\'s timeless tale of love and tragedy, capturing the intensity and purity of young love. Targeted for pre-teens and young teens, this action-packed retelling balances romance with thrilling sword fights and daring escapes. 💘⚔️🌹',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/NqSn5AOdybg?si=XbMfERZkJebDIscn',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [2,5,8],
                    'content_rating' => 'PG (Parental Guidance Suggested)',
                    'duration' => '02:50',
                    'release_date' => '2024-07-31',
                    'is_restricted' => true,
                    'actors' => [3,4,5,6,7,10,11,14,15,16,17,18],
                    'directors' => [24,25,26,27,28,29,30,31,32,34,36,37,38,40],
                    'countries' => [27,37],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/kIqzT7HIu-I?si=TV3gUqGaPWBNqkYO'
                ],
                [
                    'name' => 'Charlotte\'s Curse',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/charlottes_curse_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/charlottes_curse_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/charlottes_curse_poster.png',
                    'description' => 'When a family unknowingly brings home an antique doll, they become entangled in a chilling and haunting experience. The spirit of Charlotte, a vengeful girl trapped in the doll, begins to torment them. Unsettling occurrences grow into a full-blown terror as the family discovers Charlotte’s tragic and sinister history. As they try to rid themselves of the doll, the evil attached to it only tightens its grip, threatening to destroy them all. Will they survive, or will Charlotte’s curse claim them one by one? Prepare for a terrifying journey of suspense, fear, and the unknown in this spine-tingling horror thriller. 👻🕯️🎭',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/TY6X-vXSZjU?si=avF0vLQtTLiOzjRb',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [5,2,3],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:55',
                    'release_date' => '2024-08-01',
                    'is_restricted' => false,
                    'actors' => [13, 11, 14, 12, 5, 6],
                    'directors' => [33, 25, 34, 26, 35, 27],
                    'countries' => [37],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/G8ngi-HhojM?si=V8aeIpX390vOu7MS'
                ],
                [
                    'name' => 'Cultural Clash Comedy',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/cultural_clash_comedy_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/cultural_clash_comedy_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/cultural_clash_comedy_poster.png',
                    'description' => 'The journey of a college student who, despite being raised in a white liberal household, seeks to connect with his African American heritage. With the comedic assistance of his white best friend, they navigate the complexities of identity and family expectations. The film portrays the comedic and poignant moments as the new couple faces their parents\' conflicting views on their relationship and cultural explorations. 🎬💥',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/pCMHc-IFAB0?si=vIVQzT73CoPjbEio',
                    'movie_access' => 'paid',
                    'plan_id' => 3,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [3,4,5],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '01:50',
                    'release_date' => '2024-08-03',
                    'is_restricted' => false,
                    'actors' =>  [1,2,3,8,9,10,13,14,15,18,20],
                    'directors' => [22,24,25,27,29,31,32,33,34,35,36,37],
                    'countries' => [27,37],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/DJ0_rhsljpc?si=6KwFhULBBgZ0mKEG'
                ],
                [
                    'name' => 'Crossroads of Conflict',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/crossroads_of_conflict_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/crossroads_of_conflict_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/crossroads_of_conflict_poster.png',
                    'description' => '"Crossroads of Conflict" explores the lives of three men, each in a different war, who find themselves at a moral crossroads. As they battle on the frontlines, they must grapple with shifting alliances, moral dilemmas, and the unpredictable nature of war. Their fates are tied together in a world where violence reigns, but all is not as it seems. 🌍⚔️',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/s2-1hz1juBI?si=OG5eOFO6QnSfLiFb',
                    'movie_access' => 'paid',
                    'plan_id' => 4,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [4,5,7],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:40',
                    'release_date' => '2024-08-06',
                    'is_restricted' => false,
                    'actors' => [1,3,4,5,6,8,10,11,12,13,14,17,18],
                    'directors' => [24,25,26,27,28,29,30,31,32,34,36,37,38,40],
                    'countries' => [27,37],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/AWuxeDm1SGA?si=5rZ3rc4LnLYtmJ2u'
                ],
                [
                    'name' => 'Faithful Survival',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/faithful_survival_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/faithful_survival_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/faithful_survival_poster.png',
                    'description' => '🌟 "Faithful Survival" tells the inspiring story of 16-year-old Dior, who, after losing her family in a tragic accident, must navigate the harsh realities of life on her own. Armed with her faith and a strong sense of self, Dior faces the challenges of homelessness, prejudice, and isolation. As she struggles to make a better life for herself, she finds unexpected allies and discovers the power of hope, perseverance, and community. This powerful drama highlights the strength of the human spirit in the face of adversity and is a reminder of the transformative power of belief and resilience. 🌈💪',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/QKjZSOjzChg?si=_GIkyvBk5D53D9nJ',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [6,2,3],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:35',
                    'release_date' => '2024-08-07',
                    'is_restricted' => false,
                    'actors' => [2,4,7,8,9,12,13,14,15,16,19,20],
                    'directors' =>[21,22,25,26,27,28,29,30,34,35,36,39,40],
                    'countries' => [27,37],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/Y8rj4BTNU0Y?si=wtcpeqBE3e-EGNFY'
                ],
                [
                    'name' => 'Beneath the Surface',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/beneath_the_surface_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/beneath_the_surface_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/beneath_the_surface_poster.png',
                    'description' => '💘 A famed womanizer\'s world shifts when he meets a model whose mysterious life challenges him to reconsider his choices. As secrets are revealed, both realize that love is not just about chemistry—it\'s about vulnerability and trust. Together, they embark on a journey of self-discovery, learning that real love means facing the truth beneath the surface. 💖🌊 🌹✨💑',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/l3P2vrcKiXs?si=PG6Yj6Bff7KrDaeB',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [7,4,3],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:58',
                    'release_date' => '2024-08-10',
                    'is_restricted' => false,
                    'actors' => [3,5,6,7,8,9,10,11,12,16,17,18],
                    'directors' => [21,24,25,26,27,28,29,30,34,35,36,39,40],
                    'countries' => [27,37],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/rzR3KkzKwCY?si=jJN2ZFJz2afzdeqa',
                ],

                [
                    'name' => 'Nowhere to Hide',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/nowhere_to_hide_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/nowhere_to_hide_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/nowhere_to_hide_poster.png',
                    'description' => '"Nowhere to Hide" tells the chilling story of Sarah, who goes to extreme lengths to escape her abusive husband by staging her death. Believing she’s safe, Sarah starts over under a new identity, but the peace is short-lived when her husband learns of her survival. With her life hanging by a thread, Sarah must stay one step ahead of her dangerous pursuer, leading to a heart-stopping showdown where survival is the only option. 🖤🎯🌫️',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/7EzpvriIQ3I?si=32wWLtYpLoOf7QuP',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [8,6,5],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:50',
                    'release_date' => '2024-08-17',
                    'is_restricted' => false,
                    'actors' => [1,2,4,8,11,12,13,14,15,19,20],
                    'directors' =>[22,23,24,28,29,30,31,32,34,36,37,38,40],
                    'countries' => [27,37],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/BrDKY3RRg-g?si=SJgkbOqPdgCZCCOs'
                ],
                [
                    'name' => 'The Haunting Veil',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/the_haunting_veil_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/the_haunting_veil_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/the_haunting_veil_poster.png',
                    'description' => '👻 "The Haunting Veil" follows Tobias\' newfound romance that spirals into terror as strange accidents and unexplainable coincidences plague his life. His lover’s past is cloaked in dark secrets that, one by one, manifest as deadly forces. As Tobias unravels the mystery behind the horrifying occurrences, he finds himself trapped in a haunting web of danger and deception. Will he escape the sinister forces, or will love consume him entirely? A spine-chilling journey through love, betrayal, and supernatural horror. 👻💔🔮',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/BruiisujNJY?si=GGnUUVXqX0BfCTQC',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [3,4,5],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:56',
                    'release_date' => '2024-08-20',
                    'is_restricted' => false,
                    'actors' => [2,4,7,8,9,12,13,14,15,16,19,20],
                    'directors' =>[23,24,25,26,27,28,30,32,33,34,35,36,37,39], // Replace with actual IDs
                    'countries' => [27,37],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/ln4lDjT8Ab0?si=LIretoN3T65HTieV'
                ],
                [
                    'name' => 'Dead Zone Heist',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/dead_zone_heist_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/dead_zone_heist_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/dead_zone_heist_poster.png',
                    'description' => 'A former war hero leads a group of mercenaries into a zombie-infested Las Vegas to retrieve a fortune hidden beneath the Strip. With time running out before the city is obliterated, the team must battle intelligent zombies and survive the ultimate heist. 💀💰🧟‍♂️⏳',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/HHJkUQGm2H8?si=azs9wdvXt22o54B3',
                    'movie_access' => 'paid',
                    'plan_id' => 2,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [2,7,8],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:40',
                    'release_date' => '2024-08-23',
                    'is_restricted' => false,
                    'actors' => [1,2,3,4,8,9,10,11,13,14,16,19,20], // Replace with actual IDs
                    'directors' =>[24,25,26,27,28,29,30,31,32,34,36,37,38,40], // Replace with actual IDs
                    'countries' => [27,37],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/iwA8ooWRNBs?si=JqXh28NIx2Dgk8aA'
                ],
                [
                    'name' => 'The Cursed Frontier',
                    'thumbnail_url' => '/dummy-images/entertainment/movie/thumb/the_cursed_frontier_thumb.png',
                    'poster_tv_url' => '/dummy-images/entertainment/movie/thumb/the_cursed_frontier_thumb.png',
                    'poster_url' => '/dummy-images/entertainment/movie/poster/the_cursed_frontier_poster.png',
                    'description' => 'In a desolate horrible town, a group of friends encounters a menacing pack of wild creatures. Surrounded and threatened, they must confront their fears and work together to overcome the danger and escape the curse of the frontier. 🏜️🦝⚔️',
                    'trailer_url_type' => 'YouTube',
                    'trailer_url' => 'https://youtu.be/6sxnOLRGkhw?si=WrBfEDVah3Z-vFwO',
                    'movie_access' => 'free',
                    'plan_id' => null,
                    'status' => 1,
                    'language' => 'english',
                    'genre_id' => [1,7,8],
                    'content_rating' => 'TV-MA (Mature Audiences)',
                    'duration' => '02:45',
                    'release_date' => '2024-08-27',
                    'is_restricted' => false,
                    'actors' =>[1,3,4,5,6,8,10,11,12,13,14,17,18], // Replace with actual IDs
                    'directors' => [21,23,24,26,28,30,32,34,35,36,37,38,39,40], // Replace with actual IDs
                    'countries' => [27,37],
                    'type' => 'movie',
                    'video_upload_type' => 'YouTube',
                    'video_url_input' => 'https://youtu.be/ln4lDjT8Ab0?si=LIretoN3T65HTieV'
                ]

    ];

        if (env('IS_DUMMY_DATA')) {
            foreach ($entertainments as $entertainmentData) {
                $thumbnailPath = $entertainmentData['thumbnail_url'] ?? null;
                $posterPath = $entertainmentData['poster_url'] ?? null;
                $posterTvPath = $entertainmentData['poster_tv_url'] ?? null;

                $entertainment = Entertainment::create(Arr::except($entertainmentData, ['thumbnail_url', 'poster_url','poster_tv_url', 'genre_id', 'actors', 'directors','countries', 'stream_content']));

                if (isset($thumbnailPath)) {
                    $thumbnailUrl = $this->uploadToSpaces($thumbnailPath);
                    if ($thumbnailUrl) {
                        $entertainment->thumbnail_url = extractFileNameFromUrl($thumbnailUrl);
                    }
                }

                if (isset($posterPath)) {
                    $posterUrl = $this->uploadToSpaces($posterPath);
                    if ($posterUrl) {
                        $entertainment->poster_url = extractFileNameFromUrl($posterUrl);
                    }
                }
                if (isset($posterTvPath)) {
                    $posterTvUrl = $this->uploadToSpaces($posterTvPath);
                    if ($posterTvUrl) {
                        $entertainment->poster_tv_url = extractFileNameFromUrl($posterTvUrl);
                    }
                }
                $entertainment->save();

                foreach ($entertainmentData['genre_id'] as $genreId) {
                    EntertainmentGenerMapping::create([
                        'entertainment_id' => $entertainment->id,
                        'genre_id' => $genreId,
                    ]);
                }

                foreach ($entertainmentData['actors'] as $actorId) {
                    EntertainmentTalentMapping::create([
                        'entertainment_id' => $entertainment->id,
                        'talent_id' => $actorId,
                    ]);
                }

                foreach ($entertainmentData['directors'] as $directorId) {
                    EntertainmentTalentMapping::create([
                        'entertainment_id' => $entertainment->id,
                        'talent_id' => $directorId,
                    ]);
                }

                foreach ($entertainmentData['countries'] as $countryId) {
                    EntertainmentCountryMapping::create([
                        'entertainment_id' => $entertainment->id,
                        'country_id' => $countryId,
                    ]);
                }


                if (isset($entertainmentData['stream_content']) && is_array($entertainmentData['stream_content'])) {
                    foreach ($entertainmentData['stream_content'] as $streamContent) {
                        EntertainmentStreamContentMapping::create([
                            'entertainment_id' => $entertainment->id,
                            'quality' => $streamContent['quality'],
                            'type' => $streamContent['type'],
                            'url' => $streamContent['url'],
                        ]);
                    }
                }

            }

            Schema::enableForeignKeyConstraints();
        }
    }

    private function uploadToSpaces($publicPath)
        {
            $localFilePath = public_path($publicPath);
            $remoteFilePath = 'streamit-laravel/' . basename($publicPath);

            if (file_exists($localFilePath)) {
                // Get the active storage disk from the environment
                $disk = env('ACTIVE_STORAGE', 'local');
                if ($disk === 'local') {

                    // Store in the public directory for local storage
                    Storage::disk($disk)->put('public/' . $remoteFilePath, file_get_contents($localFilePath));
                    return asset('storage/' . $remoteFilePath);
                } else {
                    // Upload to the specified storage disk
                    Storage::disk($disk)->put($remoteFilePath, file_get_contents($localFilePath));
                    return Storage::disk($disk)->url($remoteFilePath);
                }
            }

            return false;
        }
}
